CoM=====================================================================
CoM...Get_mode: Extracts a vector from a file in CERFACS format.
CoM---------------------------------------------------------------------
CoM
CoM   Purpose:
CoM   --------
CoM  *To analyze vectors found in CERFACS vector files.
CoM  (like those produced by DIAGSTD, DIAGRTB...)
CoM
CoM   Input:
CoM   ------
CoM  *A vector number, or an effective number of coordinates involved.
CoM                   (to provide expected vector dimension)
CoM  *A coordinate file in PDB format, where atom names can be picked.
CoM
CoM   Outputs:
CoM   --------
CoM  *The vector in CERFACS format.
CoM  *The vector coordinates (3D) or its weight (1D).
CoM   The weight is the square of the vector coordinate(s).
CoM  *The mass-weighted amplitude of each atom displacement.
CoM  (for this a PDB coordinate file with the masses is required)
CoM
CoM   Properties:
CoM   -----------
CoM  *Filenames are built from vector filename (new suffix). 
CoM
CoM   This program asks a couple of questions. Just answer them.
CoM---------------------------------------------------------------------
      program Getmod
      implicit none
      integer natmax, nresmx, nmotsmax
c-----------------------------------------------------------------------
CoM
CoM   This is a fortran 77 program (Sorry), so it has predefined:
c     **************
CoM   MEMORY LIMITS:
c     **************
CoM   Increase them if needed, that is, if the program complains or
CoM   if you are studying (too) large systems. 
CoM   To (re)compile this program, type:
CoM   make get_mode
CoM   or:
CoM   g77 -o get_mode get_mode.f
CoM   or use your favorite fortran compiler instead (of g77).
CoM
c     NATMAX  : Maximum number of atoms.
c     NRESMX  : Maximum number of residues.
c     NMOTSMAX: Maximum length of filenames.
c     
      parameter( natmax=15000,
     .           nresmx=natmax,
     .           nmotsmax=256)
c-----------------------------------------------------------------------
      integer fatres(nresmx), i,  iat, idot, ii, imax, iresat(natmax), 
     .        j, jj, jmax, k, 
     .        lmot, lnom, lnomeig, lnompdb, lnomx, lnumv, 
     .        natom, nddl, neff, nmots, nres, numvec, numsel, nunit, 
     .        nwrong, prtlev,
     .        uneig, unmod, unout, unpdb, unvec
      parameter(lnomx=nmotsmax)
      double precision freq, massat(natmax), norme, normtot,
     .        rave, rdev, rmax, rmin, vector(3*natmax), 
     .        xat(natmax), xmod, yat(natmax), ymod, zat(natmax), zmod
      logical qchm, qerror, qexist, qok, qinter, qlist, qmasse, q3d
      character atonam(nresmx)*4, 
     .        cformat*12, cnum*6, cominp*4, cstatus*12, 
     .        mots(nmotsmax)*(lnomx), 
     .        namfil*(lnomx), nomeig*(lnomx), nompdb*(lnomx), 
     .        program*8, progrer*11, progrwn*11, 
     .        resnam(natmax)*4, segid(natmax)*4, ssunam(natmax)*1, 
     .        ssusel*1, version*40
CoM   This software is released under the CeCILL FREE SOFTWARE LICENSE.
CoM   In short: this license is compatible with the GNU GPL.
CoM   Specifically: it grants users the right to modify and redistribute 
CoM   this software within the framework of an open source distribution 
CoM   model. The complete text of the license can be found there:
CoM   http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
CoM------------------------------------------------------------------- 
CoM   In case of problem(s), feel free to tell:
CoM   Yves-Henri.Sanejouand@univ-nantes.fr (bug report also help others).
CoM---------------------------------------------------------------------
c     YHS-Jan-97: Premiere version (Toulouse).
      version=' Version 1.39, December 2014.'
      program=' Getmod>'
 
      write(6,'(2A)') program,
     .    ' Extracts a vector from a file in CERFACS format.'
      write(6,'(2A)') program,version
 
      progrwn='%Getmod-Wn>'
      progrer='%Getmod-Er>'
      qchm=.false.
      prtlev=0

      call getnam('Eigenvector filename ?',nomeig,lnomeig,qok)
      if (.not.qok) stop '*Wrong filename*'
      if (lnomeig.eq.lnomx) 
     .    write(6,'(2A)') progrwn,
     .  ' Long name. Please check that it has not been shortened.'
 
      numsel=-1
      call getnum('Eigenvector Number ?',numsel,-1,3*natmax,qok)
      if (.not.qok) stop '*Unexpected vector number*'

      neff=0
      if (numsel.le.0) then
          call getnum(
     .   'Minimum effective number of coordinates involved ?',neff,
     .    0,3*natmax,qok)
          if (.not.qok) stop '*Unexpected integer number*'
      endif
 
      nunit=10
      uneig=nunit
      nunit=nunit+1
      cformat="FORMATTED"
      cstatus="old"
      call openam(nomeig,lnomeig,cformat,cstatus,uneig,.true.,
     .            qinter,qexist)
      if (qinter.or..not.qexist) stop
 
      qmasse=.false.
      call getnam('Corresponding pdb file ? (can be NONE)',
     .     nompdb,lnompdb,qok)
      if (lnompdb.eq.lnomx) 
     .    write(6,'(2A)') progrwn,
     .  ' Long name. Please check that it has not been shortened.'

      if (qok.and.lnompdb.eq.4) then
          cominp=nompdb
          call mintomaj(cominp)
          if (cominp.eq.'NONE') qok=.false.
      endif 
 
      if (.not.qok) then
          qlist=.true.
          goto 100
      else
          qlist=.false.
      endif

      call string_split(nompdb,lnompdb,':',
     .                  mots,nmotsmax,nmots)
      call stringcl(mots(1),lmot)
 
      if (nmots.gt.1) then
          call stringcl(mots(2),lmot)
          ssusel=mots(nmots)
          write(6,'(3A)') program,' Subunit to be selected: ',ssusel
          if (nmots.gt.2) then
              write(6,'(4A)') progrer,
     .      ' The end of pdb name, ',
     .        nompdb(1:lnompdb),', has not been understood.'
          endif
      else
          ssusel=' '
      endif
      nompdb=mots(1)
 
      unpdb=nunit
      nunit=nunit+1
      call openam(nompdb,lnompdb,cformat,cstatus,unpdb,.true.,
     .            qinter,qexist)

      if (qinter.or..not.qexist) then
          if (q3d) write(6,'(2A)') progrwn,
     .  ' Atom names and masses will be missing.'
          qlist=.true.
          goto 100
      endif
 
      call getrep(
     .    'Are the masses given in the pdb files ? (y/n)',
     .     qmasse,qok)
      if (.not.qok) qmasse=.false.

c     Lecture du mode:
c     ================
      q3d=.false.
 100  continue
      write(6,'(/2A,I5,A)') program,
     .  ' Vector ',numsel,' to be read and stored.'

      call rd1modfacs(uneig,3*natmax,numsel,neff,numvec,qchm,
     .     freq,vector,nddl,qok,prtlev)
      if (.not.qok) stop '*Required*'

      write(6,'(2A,I5,A)') program,' It has ',nddl,
     .  ' degrees of freedom.'
      if (nddl.eq.0) stop '*Not enough*'

c     Lecture des coordonnees:
c     ========================
      if (qlist) goto 200 
      call rdallatpdb(unpdb,ssusel,xat,yat,zat,massat,
     .     atonam,iresat,resnam,ssunam,segid,natmax,natom,
     .     fatres,nresmx,nres,qerror)
 
      if (nddl.eq.3*natom) then
          write(6,'(/2A)') program,
     .  ' A cartesian (eigen)vector is considered.'
          q3d=.true.
      else if (nddl.gt.0) then
          if (nddl.eq.natom) then
          write(6,'(/2A)') program,
     .  ' An atom-based (eigen)vector is considered.'
          else
          write(6,'(/2A,I6)') progrer,
     .  ' Eigenvector read is of order ',nddl
          write(6,'(2A)') progrer,
     .  ' Expected: same, or three times the number of atoms.'
          write(6,'(2A)') progrer,
     .  ' Vector and reference pdb file are not consistent.'
          stop '*They need to be*'
          endif
      else if (nddl.le.0) then
          write(6,'(/2A)') progrer,' Nothing can be done.'
          stop '*Empty, or wrong file ?*'
      endif
 
      if (qmasse) then
      nwrong=0
      do i=1,natom
         if (massat(i).le.0.d0) nwrong=nwrong+1
      enddo
      if (nwrong.gt.0) then
         write(6,'(/A,I6,A)') progrwn,nwrong,
     . ' non-positive mass values read in the B-factor column '//
     .  'of the PDB file.'
         qmasse=.false.
      endif
c     qlist:
      endif

c     Sortie:
c     =======
 200  continue
c     Pour les noms de fichier:
      idot=-1
      do i=1,lnomeig
         if (nomeig(i:i).eq.'.') idot=i
      enddo

      if (qmasse) then
          write(6,'(/2A)') program,
     .  ' Masses have been picked in the PDB file.'
          call rvecstat(massat,natom,rmin,rmax,rave,rdev,.true.)
      endif

      write(cnum,'(I6)') numsel
      call stringcl(cnum,lnumv)

c     Norme pour chaque atome:
c     ------------------------
      if (q3d.and..not.qlist) then
      if (idot.gt.1.and.idot+lnumv+8.le.lnomx) then
      namfil=nomeig(1:idot-1)//'_mod'//cnum(1:lnumv)//'.norm'
      lnom=idot+lnumv+8
      else
      namfil='rmsmod.res'
      lnom=10
      endif

      unout=nunit
      nunit=nunit+1
      cformat="FORMATTED"
      cstatus="ove"
      call openam(namfil,lnom,cformat,cstatus,unout,.true.,
     .            qinter,qexist)

      write(6,'(2A)') program,
     .' Displacement=f(atom number) to be written in this file.'
      write(unout,'(2A)') program,version
      write(unout,'(2A,I6,2A)') program,' Vector',numsel,
     .   ', from file ',nomeig(1:lnomeig)
      write(unout,'(A)')' Atom,  Norm'

      normtot=0.d0
      do i=1,natom
         ii=3*i-2
         norme=vector(ii)**2.d0+
     .         vector(ii+1)**2.d0+
     .         vector(ii+2)**2.d0
         normtot=normtot+norme
         if (.not.qlist) then
              if (qmasse) norme=norme/massat(i)
              norme=dsqrt(norme)
              write(unout,'(I6,1X,A,I6,X,A,1X,A,1X,F8.4)') 
     .        i,resnam(i),iresat(i),ssunam(i),atonam(i),norme
         endif 
      enddo
      endif

c     Coordonnees du vecteur extrait:
c     -------------------------------
      if (idot.gt.1.and.((q3d.and.idot+lnumv+7.le.lnomx).or.
     .                   (.not.q3d.and.idot+lnumv+9.le.lnomx))) then
      if (q3d) then
      namfil=nomeig(1:idot-1)//'_mod'//cnum(1:lnumv)//'.xyz'
      lnom=idot+lnumv+7
      else
      namfil=nomeig(1:idot-1)//'_mod'//cnum(1:lnumv)//'.xnorm'
      lnom=idot+lnumv+9
      endif
      else
      namfil='eigvec.res'
      lnom=10
      endif
 
      unmod=nunit
      nunit=nunit+1
      cstatus="ove"
      call openam(namfil,lnom,cformat,cstatus,unmod,.true.,
     .            qinter,qexist)
      if (qinter) stop '*Unexpected interruption*'

      if (q3d) then 
      write(6,'(2A)') program,
     .' Vector coordinates=f(atom number) to be written in this file.'
      else
      write(6,'(2A)') program,
     .' Vector coordinates to be written in this file.'
      endif
 
      write(unmod,'(2A)') program,version
      write(unmod,'(2A,I6,2A)') program,' Vector',numsel,
     .   ', from file ',nomeig(1:lnomeig)

      if (q3d) then
      if (qlist) then
      write(unmod,'(A)')'  Atom    x       y       z '
      else
      write(unmod,'(A)')'  Atom Amino-acid  x  y  z'
      endif

      do i=1,nddl,3
         iat=(i+2)/3
         xmod=vector(i)
         ymod=vector(i+1)
         zmod=vector(i+2)
         if (qmasse) then
             xmod=xmod/dsqrt(massat(iat))
             ymod=ymod/dsqrt(massat(iat))
             zmod=zmod/dsqrt(massat(iat))
         endif
         if (qlist) then
             write(unmod,'(I6,3F8.4)') iat,xmod,ymod,zmod
         else
             write(unmod,'(I6,X,A,I6,1X,A,1X,A,1X,3F8.4)') 
     .       iat,resnam(iat),iresat(iat),ssunam(iat),atonam(iat),
     .       xmod,ymod,zmod
         endif
      enddo

c     Not q3d:
      else
      if (qlist) then
      write(unmod,'(A)')' Coordinate-index, coordinate, weight'
      else
      write(unmod,'(A)')' Atom, coordinate, weight'
      endif

      normtot=0.d0
      do i=1,nddl
         if (qlist) then
         write(unmod,'(I6,2(1X,F10.6))') i,vector(i),vector(i)**2.d0
         else
         write(unmod,'(I6,1X,A,1X,I5,1X,A,1X,A,2(1X,F10.6))') i,
     .   resnam(i),iresat(i),ssunam(i),atonam(i),
     .   vector(i),vector(i)**2.d0
         endif
         normtot=normtot+vector(i)**2.d0
      enddo
      normtot=dsqrt(normtot)
      endif

      if (qchm) then
          write(6,'(/2A,I5,A,F10.3,A,F8.4)') program,
     .  ' Vector number ',numsel,', Frequency = ',freq,
     . ', norm= ',normtot 
      else 
          write(6,'(/2A,I5,A,F10.3,A,F8.4)') program,
     .  ' Vector number ',numsel,', Eigenvalue= ',freq,
     . ', norm= ',normtot 
      endif
 
      if (idot.gt.1.and.idot+lnumv+13.le.lnomx) then
      namfil=nomeig(1:idot-1)//'_mod'//cnum(1:lnumv)//'.eigenfacs'
      lnom=idot+lnumv+13
      else
      namfil='vector.eigenfacs'
      lnom=16
      endif
      unvec=nunit
      nunit=nunit+1
      cstatus="ove"
      call openam(namfil,lnom,cformat,cstatus,unvec,.true.,
     .            qinter,qexist)
      if (qinter) stop '*Vector file not opened*'

      write(unvec,'(A,I5,7X,A,1PG12.4)')
     .    ' VECTOR',numsel,'VALUE',freq
      write(unvec,'(1X,35(1H-))')
      write(unvec,'(3(1PG12.4))') (vector(i),i=1,nddl)

      write(6,'(/2A,I6,A)') program,' Vector ',numsel,
     .    ' saved in CERFACS format.'
 
      write(6,'(/2A)') program,' Normal end.'
 
      stop
      end
c=======================================================================
      subroutine getnum(message,numlu,nummin,nummax,qok)
c
c     NUMLU obtenu en reponse au MESSAGE.
c     NUMLU doit etre inferieur a nummax et superieur a nummin.
c
c     NTRYMX essais en cas de probleme.
c     qok=.false. => Probleme a la lecture.
c
c     YHS-oct-1996: version 1.0
c     YHS-nov-2000: version 3.0
c
      implicit none
cI/O:
      integer numlu, nummax, nummin
      logical qok
      character*(*) message
cLocal:
      integer ntry, ntrymx, iread
cBegin:
      ntrymx=5
c
      qok=.false.
      ntry=0
c
 100  continue
      ntry=ntry+1
      if (ntry.ge.ntrymx) return
c
      write(6,'(A,A)') ' Getnum> ',message
      read(5,*,end=200,err=100) iread
      numlu=iread
c
      write(6,*) 'Getnum> ',numlu
      if (numlu.gt.nummax) then
          write(6,'(A,I6,A)') 
     .  '%Getnum-Err: number larger than ',nummax,
     .  ' This is not allowed. Sorry.'
          numlu=nummax
          return
      else if (numlu.lt.nummin) then
          write(6,'(A,I6,A)') 
     .  '%Getnum-Err: number smaller than ',nummin,
     .  ' This is not allowed. Sorry.'
          numlu=nummin
          return
      endif
c
      qok=.true.
      return
 200  continue
      return
      end 
c---------------------------------------------------
      subroutine getnam(message,nomlu,lnomlu,qok)
c
c     NOMLU obtenu en reponse au MESSAGE.
c     NTRYMX essais en cas de probleme.
c     YHS-oct-96
c
      implicit none
cI/O:
      integer lnomlu
      logical qok
      character*(*) message, nomlu
cLocal:
      integer ntry, ntrymx
cBegin:
      ntrymx=5
c
      qok=.false.
      ntry=0
c
 100  continue
      ntry=ntry+1
      if (ntry.ge.ntrymx) return
c
      write(6,'(A,A)') ' Getnam> ',message
      read(5,'(A)',end=200,err=100) nomlu
c
      call stringcl(nomlu,lnomlu)
      write(6,'(A,A)') ' Getnam> ',nomlu(1:lnomlu)
c
      qok=.true.
      return
 200  continue
      return
      end 
c-----------------------------------------------------------------------
      subroutine rd1modfacs(uneig,nddlmx,numsel,neff,numvec,qchm,freq,
     .           vector,nddl,qok,prtlev)
CoS=====================================================================
CoS...Rd1modfacs: Reads a single vector from a file in CERFACS format.
CoS---------------------------------------------------------------------

c     NUMSEL: The vector number to be read.
c     NEFF  : The minimum effective number of coordinates involved.
c     The second criterium is used if NUMSEL is not positive.

c     NUMVEC: The (relative) vector number read.

c     If the required vector is found and read then qok=T.
CoS
CoS   CERFACS format is produced by DIAGRTB, DIAGSTD, BLZPACK.
c   
c     YHS-Jan-05: First version (Lyon), from rdmodfacs.
c     YHS-Jan-05: v1.10 (Lyon).
c     YHS-Oct-10: v2.03.
c.......................................................................
cI/O:
      logical qchm, qok
      integer nddl, nddlmx, neff, numsel, numvec, prtlev, uneig
      double precision freq, vector(*)
cLocal:
      integer nmotsmax
      parameter(nmotsmax=100)
      integer indnm_cfacs, ivec, nerr, nmots, numrd,
     .        i, ii, j, jj, k, kk
      double precision coll, neffrd, norm, wtofreq
      logical qfound, qnumb, qold
      character carnum*1, lign132*132, mots(nmotsmax)*132, nom*10, 
     .        program*12, progrer*15, progrwn*15
cDefaut:
      nom='Rd1modfacs'
      program=' '//nom//'>'
      progrwn='%'//nom//'-Wn>'
      progrer='%'//nom//'-Er>'

      if (prtlev.gt.1) write(6,'(2A)') program,' Entering in.'
      qok=.false.

      if (numsel.gt.0) then
          qnumb=.true.
      else
          qnumb=.false.
      endif

c     Facteur de conversion des unites charmm (2*pi*f)**2 -> f (cm-1):
      wtofreq=108.586698

c     Recherche du premier mode:
c     --------------------------
      nerr=0
      qold=.false.
      qfound=.false.
 100  continue
      read (uneig,'(A)',end=300,err=110) lign132
      goto 120
 110  continue
      nerr=nerr+1
 120  continue
 
      qfound=qfound.or.
     .      (index(lign132,' value ').gt.0.and.
     .       index(lign132,' vector ').gt.0.and.
     .       index(lign132,' residual ').le.0)
      qold=qold.or.
     .      (index(lign132,' VALUE ').gt.0.and.
     .       index(lign132,' VECTOR ').gt.0)
 
      if (.not.qfound.and..not.qold) goto 100

      if (prtlev.gt.0) then
      if (qold) then
          write(6,'(/2A)') program,
     .  ' Old Blzpack file format detected.'
      else
          write(6,'(/2A)') program,
     .  ' CERFACS file format detected.'
      endif
      endif
 
c     Lecture des numeros des modes :
c     _______________________________ 
 
      ivec=0
 250  continue
      ivec=ivec+1

      if (qok) then
        if (.not.qnumb) numsel=numrd
        if (prtlev.le.0) then
          write(6,'(/2A,I6)') program,
     .      ' CERFACS vector number read : ',numrd
          if (qchm) then
              write(6,'(2A,1PG14.4)') program,
     .      ' Frequency of vector read   : ',freq
          else
              write(6,'(2A,1PG14.4)') program,
     .      ' Eigenvalue of vector read  : ',freq
          endif
        else
          write(6,'(/2A,I6,A)') program,' Vector ',numsel,' read.'
        endif
        if (.not.qnumb) 
     .  write(6,'(2A,F8.1)') program,
     .      ' Nb of coordinates involved : ',neffrd
        numvec=ivec-1
        return
      endif
 
      read(lign132,'(7X,I5,12X,G12.4)',end=240,err=240)
     .     numrd, freq

      if (qchm) freq=wtofreq*dsqrt(abs(freq))

c     Le vecteur va etre lu.
      if (numrd.eq.numsel) qok=.true.
      goto 255

 240  continue
      write(6,'(/4A)') progrer,
     .    ' Pb with ligne: ',lign132(1:36),'...'

 255  continue
      if (prtlev.gt.0) then
      write(6,'(/2A,I6)') program,
     .  ' CERFACS vector number to be read : ',numrd
      if (qchm) then
          write(6,'(2A,1PG12.4)') program,
     .  ' Frequency of vector to be read   : ',freq
      else
          write(6,'(2A,1PG14.4)') program,
     .  ' Eigenvalue of vector to be read  : ',freq
      endif
      endif
 
      if (numrd.le.0)
     .    write(6,'(/2A/A)') progrwn,
     .  ' Vector number was expected in:',lign132
 
      read(uneig,'(A)',end=230,err=230) lign132
 230  continue
      read(lign132,'(1X,A1)',end=232,err=232) carnum
 232  continue
      if ((qfound.and.carnum.ne.'=').or.
     .    (qold.and.carnum.ne.'-')) then
          write(6,'(2A/A)') progrwn,
     .       ' Unexpected character in second column of line:',
     .    lign132
      endif
 
c     2) Lecture des coordonnees des modes CERFACS :
c     ______________________________________________ 
      k=0
 257  continue
      if (k.gt.nddlmx) then
          write(6,'(/2A,I6,A,I5)') progrer,
     .  ' More than ',nddlmx,' coordinates for vector ',ivec
          return
      endif
 
      read(uneig,'(A)',end=300,err=270) lign132
 
c     Nombre de coordonnees par ligne:
      call string_split(lign132,132,' ',mots,nmotsmax,nmots)
 
      if (lign132.eq.' ') then
          read(uneig,'(A)',end=300,err=260) lign132
      else if (.not.qold.or.index(lign132,' VALUE ').le.0) then
          read(lign132,*,end=258) (vector(k+ii),ii=1,nmots)
          k=k+nmots
          nddl=k
          goto 257
 258      continue
      endif

c     Calcul eventuel du nombre de coordonnees effectives:
      if (.not.qnumb) then 
        norm=0.d0
        do i=1,nddl
           norm=norm+vector(i)**2.d0
        enddo 
        coll=0.d0
        if (norm.gt.0.d0) then
        do i=1,nddl
           wcoor=vector(i)**2.d0/norm
           if (wcoor.gt.0.d0) coll=coll-wcoor*log(wcoor)
        enddo 
        neffrd=exp(coll)
        if (neffrd.gt.dfloat(neff)) qok=.true.
        endif
      endif

 260  continue
      indnm_cfacs=index(lign132,'       VALUE')
      if (indnm_cfacs.le.0)
     .    indnm_cfacs=index(lign132,'       value')
      if (indnm_cfacs.gt.0) then
          goto 250
      else
          write(6,'(3A/A)') progrwn,
     .  ' All CERFACS vectors have been read.',
     .  ' item VALUE not found as expected in ligne: ',lign132
          goto 300
      endif
 
 270  continue
      write(6,'(2A,I6)') progrer,' While reading coordinate ',i
      stop '*Wrong vector file*'
 
c     Next ligne:
 220  continue
      goto 100
 
c     Fin de la lecture du fichier des modes :
 300  continue
      if (.not.qok) 
     .    write(6,'(2A,I6,A)') progrer,' Vector ',numsel,' not found.'

      return
      end
c-----------------------------------------------------------------------
      subroutine openam(namfil,lnom,cformat,cstatus,unit,qverbos,
     .                  qinterr,qexist)
c======================================================================= 

c     Ouverture d'un fichier de nom NAMFIL, sur l'unite UNIT.
 
c======================================================================= 
c     input:
c        namfil: nom du fichier a ouvrir. 
c        lnom: longueur de ce nom.
c       "stop", "end", "fin", "quit" : arretent le programme.
c        cstatus: mots-cles fortran... ou "OVE" pour overwrite.

c     output: 
c        qexist: flag / existence du fichier 
c        qinterr: Pas de nom pour le fichier cherche.
 
c.......................................................................
c     YHS-oct-1993: Premiere version.
c     YHS-jul-2007: v1.5
c.......................................................................
      logical qexist, qinterr, qverbos
      integer lnom, unit
      character cformat*12, cstatus*12, namfil*(*)
c Local
      character ordrunix*132
c Begin:
      if (cstatus.eq.'old') cstatus='OLD'
      if (cstatus.eq.'new') cstatus='NEW'
      if (cstatus.eq.'ove') cstatus='OVE'
      if (cstatus.eq.'unknown') cstatus='UNKNOWN'
 
      qinterr=.false.
      qexist=.false.
 
      if (namfil.eq.' ') then 
          qinterr=.true.
          write(6,'(A)') '%Openam-Err> No filename.'
          return
      endif
 
      if (namfil.eq.'stop'.or.namfil.eq.'end'.or. 
     .    namfil.eq.'fin'.or.namfil.eq.'quit'.or.
     .    namfil.eq.'STOP'.or.namfil.eq.'END'.or.                     
     .    namfil.eq.'FIN'.or.namfil.eq.'QUIT') then 
         write(6,'(A)') 'Openam> Program stopped on user request.'
         stop '*As you wish*'
      endif 
 
c     Checks if filename is consistent with the opening:
 
      inquire(file=namfil,exist=qexist)
      if (.not.qexist.and.cstatus.eq.'OLD') then
          qinterr=.true.
          write(6,'(/3A)') '%Openam-Err> File <',
     .         namfil(1:lnom),'> not found.'
          return
      endif
 
      if (qexist.and.cstatus.eq.'NEW') then
         write(6,'(/A)') 
     .      '%Openam-Err> This file exists:',namfil(1:lnom)
         stop '*Should not*'
      else if (qexist.and.cstatus.eq.'OVE') then
         ordrunix='rm '//namfil(1:lnom)
         call system(ordrunix)
      endif
      if (cstatus.eq.'OVE') cstatus='NEW'
                                                                    
      if (qverbos) then
         write(6,'(/A,I2,2A)')
     . ' Openam> File on opening on unit ',unit,': ',namfil(1:lnom)
      endif
      open(file=namfil,form=cformat,
     .     status=cstatus,unit=unit)                
         
      return                                                                       
      end
      subroutine string_split(chaine,taille,delimiteur,
     .                        souschaine,nbremax,nbre)
c
c     "Chaine" est coupee en "nbre" "souschaine" de part et d'autre du
c     "delimiteur"
c      YHS-Sep-93, Uppsala
c I/O:
      integer taille, nbremax, nbre
      character*(*) chaine, souschaine(*), delimiteur
c Local:
      integer icar, iprev
c
      nbre=1
      iprev=1
      souschaine(1)=chaine
      do icar=1,taille
         if (chaine(icar:icar).eq.delimiteur) then
            if (icar-1.ge.iprev) then
               souschaine(nbre)=chaine(iprev:icar-1)
               nbre=nbre+1
               if (nbre.le.nbremax) then
                  if (icar+1.le.taille.and.
     .               chaine(icar+1:taille).ne.' ') then
                     souschaine(nbre)=chaine(icar+1:taille) 
                  else
                     nbre=nbre-1
                     return
                  endif
               else
                  write(6,'(A,I6,A/A)') 
     .               ' %String_split-Err: more than ',nbremax,
     .               ' substrings in : ',chaine
                  return
               endif
            endif
            iprev=icar+1
         endif
      enddo
c
      return
      end
c
      subroutine stringcl(chaine,nonblancs)
c
c     Les caracteres "blancs" de la CHAINE sont retires (a gauche et au milieu).
c     L'entier NONBLANCS donne la position du dernier caractere.
c
c     YHS-Jan-95, Toulouse.
c     YHS-Oct-00, Bordeaux.
c I/O:
      integer nonblancs
      character*(*) chaine
c Local:
      integer icar, ncar, taille
c Begin:
      nonblancs=0
      taille=len(chaine)
      if (taille.le.0) return
c
      if (index(chaine(1:taille),' ').le.0) then
          nonblancs=taille
          return
      endif
c
c*****Nettoyage des blancs a gauche.
c     Premier non-blanc:
c
      do icar=1,taille
         if (chaine(icar:icar).ne.' ') goto 150
      enddo
      icar=taille
 150  continue
      chaine=chaine(icar:taille)
c
c*****Nettoyage des blancs au milieu.
c
          icar=1
          ncar=1
 170      continue
          icar=icar+1
          ncar=ncar+1
          if (chaine(icar:icar).eq.' ') then
              chaine=chaine(1:icar-1)//chaine(icar+1:taille) 
              icar=icar-1
          endif
          if (ncar.lt.taille-1) goto 170
c
      nonblancs=index(chaine,' ')-1
c
      return
      end
c-----------------------------------------------------------------------
      subroutine rdallatpdb(unpdb,ssusel,xat,yat,zat,binfo,
     .           atonam,iresat,resnam,ssunam,segid,natmax,natom,
     .           fatres,nresmx,nres,qerror)
CoS---------------------------------------------------------------------
CoS   Rdallatpdb: A PDB file is read one line after the other.
CoS   
CoS   Only lines starting with 'ATOM' or 'HETA'(tm) are read.
CoS   Only lines with the selected chain are kept.
CoS   Only the first MODEL is considered. 
CoS---------------------------------------------------------------------
c     fatres(i): numero du premier atome du residu i.
c     YHS-Jun-1997: Premiere version (Toulouse).
c     YHS-Nov-2006: Version 2.1 (Lyon).
c     YHS-Sep-2012: Version 2.3 (Nantes).

      implicit none
cI/O:
      integer fatres(*), iresat(*), lnom, natmax, natom, 
     .        nres, nresmx, unpdb
      logical qerror
      double precision binfo(*), xat(*), yat(*), zat(*)
      character atonam(*)*4, resnam(*)*4, 
     .        segid(*)*4, ssunam(*)*1, ssusel*1
cLocal:
      integer iatom, irs, nerr, i, j, k, ii
      double precision bfact, x, y, z
      character atncur*5, lign80*80, ren*4, segat*4, ssu*1 
cBegin:
      write(6,'(/A)') ' Rdallatpdb> Reading pdb file.'
 
      qerror=.false.
      nerr=0
 
      fatres(1)=1
      nres=1
      iatom=0
 105  continue   
      read(unpdb,'(A)',end=200,err=110) lign80 
  
      goto 120                                
 110  continue
      nerr=nerr+1                            
 
 120  continue                              
      if (lign80(1:4).eq.'ATOM'.or.lign80(1:4).eq.'HETA') then
      segat=' '
      read(lign80,'(12X,A4,1X,A4,A1,I7,1X,3F8.3,6X,F6.2,6X,A4)',
     .     end=195,err=195) 
     .            atncur, ren, ssu, irs, x, y, z, 
     .            bfact, segat

      if (iatom.lt.natmax) then
          if (ssu.eq.ssusel.or.ssusel.eq.' ') then
          iatom=iatom+1
          xat(iatom)=x
          yat(iatom)=y
          zat(iatom)=z
          binfo(iatom)=bfact
 
          call stringcl(atncur,lnom)
          atonam(iatom)=atncur
          call stringcl(ren,lnom)
          resnam(iatom)=ren
          ssunam(iatom)=ssu
          iresat(iatom)=irs
          segid(iatom) =segat
 
          i=iatom
          if (i.gt.1.and.(iresat(i).ne.iresat(i-1).or.
     .        resnam(i).ne.resnam(i-1).or.ssunam(i).ne.ssunam(i-1)))then
              nres=nres+1
              if (nres.gt.nresmx) then
                  write(6,'(A/A,I6)') 
     .          '%Rdallatpdb-Er> Too many residues in this file.',
     .          ' Maximum allowed is = ',nresmx
                  stop '*Larger array required*'
              endif
              fatres(nres)=iatom
          endif
          endif
      else
          write(6,'(A/A,I6)') 
     .      '%Rdallatpdb-Er> Too many atoms in this file.',
     .      ' Maximum allowed is = ',natmax
          stop '*Larger array required*'
      endif
      elseif (lign80(1:6).eq.'ENDMDL') then
          write(6,'(/A)') 
     .  '%Rdallatpdb-Wn> ENDMDL encountered. Remaining ignored.'
          goto 200
      endif
 
c     2) Ligne suivante du fichier pdb :
 
      goto 105

c     3) Fin de la lecture du fichier pdb :
 
c     Erreur de lecture:
 195  continue
      write(6,'(/A/A)') '%Rdallatpdb-Er> Unable to read ligne: ',lign80
      qerror=.true.

c     Fin du fichier: 
 200  continue 
      write(6,*) 'Rdallatpdb> End of file reached.'
      write(6,*) 'Rdallatpdb> Number of I/O errors: ',
     .            nerr
 
      natom=iatom
      fatres(nres+1)=natom+1
      irs=0
      if (natom.gt.0) irs=iresat(natom)
 
      write(6,'(/(A,I6))') 
     .' Rdallatpdb> Number of residues found = ',nres,
     .'             First residue number     = ',iresat(1),
     .'             Last  residue number     = ',irs,
     .'             Number of atoms found    = ',natom
      write(6,'(A,F8.1)') 
     .'             Mean number per residue  = ',
     .              float(natom)/float(nres)
 
      if (natom.eq.0) then
          write(6,'(A)')
     .  '%Rdallatpdb-Er> No atom found in file.'
          qerror=.true.
      endif
      if (nres.eq.0) then
          write(6,'(A)')
     .  '%Rdallatpdb-Er> No residue found in file.'
          qerror=.true.
      endif
 
      close(unpdb)
      return
      end
c---------------------------------------------------
      subroutine getrep(message,qinfo,qok)
c
c     qinfo obtenu en reponse au MESSAGE.
c     NTRYMX essais en cas de probleme.
c     YHS-jan-00
c     YHS-oct-00
c
      implicit none
cI/O:
      logical qok, qinfo
      character*(*) message
cLocal:
      integer ntry, ntrymx
      character*1 cread
cBegin:
      ntrymx=2
c
      qinfo=.false.
      qok=.false.
      ntry=0
c
 100  continue
      ntry=ntry+1
      if (ntry.ge.ntrymx) then
          goto 200
          return
      endif
c
      write(6,'(A,A)') ' Getrep> ',message
      read(5,'(A)',end=200,err=100) cread
c
      if (cread.eq.'T'.or.cread.eq.'t'.or.
     .    cread.eq.'Y'.or.cread.eq.'y'.or.
     .    cread.eq.'O'.or.cread.eq.'o') then
          qinfo=.true.
      else
      if (cread.ne.'F'.and.cread.ne.'f'.and.
     .    cread.ne.'N'.and.cread.ne.'n')
     .    write(6,'(3A)') '%Getrep-W> Unexpected answer:',cread,
     . '. Assumed answer is: NO.'
      endif
c
      write(6,*) 'Getrep> ',qinfo
c
      qok=.true.
      return
 200  continue
      write(6,'(A)') '%Getrep-W> No answer.'//
     .    ' Assumed answer is: NO.'
      return
      end 
c-----------------------------------------------------------------------
      subroutine mintomaj(chaine)
 
c     Les caracteres minuscules sont mis en MAJUSCULES.
c     Les autres ne sont pas touches.
 
c     YHS-Oct-98: Premiere version (Toulouse).
c     YHS-Sep-03: Dernieres modifications (Lyon).
 
      character*(*) chaine
c Local:
      integer icar, ilettre, taille
      character*26  carmaj, carmin
 
      carmin='qwertyuiopasdfghjklzxcvbnm'
      carmaj='QWERTYUIOPASDFGHJKLZXCVBNM'
 
      taille=len(chaine)
      if (taille.le.0) return

      do icar=1,taille
         ilettre=index(carmin,chaine(icar:icar))
         if (ilettre.gt.0) then
             chaine(icar:icar)=carmaj(ilettre:ilettre)
         endif
      enddo
 
      return
      end
c-----------------------------------------------------------------------
      subroutine rvecstat(vect,nmax,rmin,rmax,rave,rdev,qprint)
CoS=====================================================================
CoS...Rvecstat: Statistics for a REAL vector.
CoS---------------------------------------------------------------------
CoS
CoS   Minimum, maximum, average (rave) and standard deviation (rdev).
CoS
CoS   Input: REAL vector Vect(NMAX):
CoS
c     YHS-Sep-03: First version (Lyon).
c     YHS-Oct-07: version 1.03 (Lyon).
c     YHS-Fev-11: version 1.04 (Nantes).
cI/O:
      integer nmax
      logical qprint
      double precision rave, rdev, rmax, rmin, vect(*)
cLocal:
      integer i
      character program*10, progrer*13, progrwn*13

cBegin:
      program=' Rvecstat>'
      progrer='%Rvecstat-Er>'
      progrwn='%Rvecstat-Wn>'

      rave=0.d0
      rdev=0.d0
      rmin=-9999.d0
      rmax=9999.d0

      if (nmax.le.0) then
          write(6,'(2A)') progrer,' Zero-length vector.'
          return
      endif

      do i=1,nmax
         if (vect(i).gt.rmax.or.i.eq.1) rmax=vect(i)
         if (vect(i).lt.rmin.or.i.eq.1) rmin=vect(i)
         rave=rave+vect(i)
         rdev=rdev+vect(i)**2.0
      enddo

      rave=rave/dfloat(nmax) 
      rdev=rdev/dfloat(nmax)-rave*rave
      if (rdev.gt.0.d0) rdev=dsqrt(rdev)

      if (qprint) then
          write(6,'(A,2(A,1PG14.6))') program,'  Mean = ',
     .    rave,' +/- ',rdev 
          write(6,'(A,2(A,1PG14.6))') program,'  Mini = ',
     .    rmin,' Mx: ',rmax
      endif

      return
      end
