CoM===================================================================== 
CoM...Proj_modes: PROJection of a difference-vector on MODes.
CoM---------------------------------------------------------------------
CoM
CoM   Purpose:
CoM   ++++++++
CoM
CoM   To compare a motion, described with two structures supposed
CoM   to be the end-points of the motion, to a set of modes.
CoM
CoM   Input: 
CoM   ++++++
CoM
CoM   This program asks a couple of questions. Just answer them.
CoM
CoM   Output: 
CoM   +++++++
CoM
CoM   projmod.res and projmod.amplitudes files are produced
CoM   The latter can be a sorted one.
CoM   Atomic displacements are saved in dr.res.
CoM
CoM   Properties: 
CoM   +++++++++++
CoM
CoM  *A least square fit between the reference PDB and the other 
CoM   conformer MUST have been performed. 
CoM   For that, you may (for instance) use the Profit program.
CoM   If not, projections on zero-frequency modes (overall translation or 
CoM   rotation modes) become significantly larger than zero, and
CoM   projections on the other modes are meaningless.
CoM
CoM  *Non-zero projections on zero-frequency modes can also be obtained 
CoM   if mass ponderation is not consistent, herein and when the modes
CoM   were computed.
CoM
CoM  *The reference PDB and the other conformer can have a different
CoM   number of atoms. In that case, only common atoms are considered.
CoM   But, then, the cumulative square of the overlaps of the
CoM   difference-vector with all modes can exceed 100%.
CoM
CoM  *Modes must be in CERFACS format (as produced by DIAGSTD, DIAGRTB):
CoM   VECTOR eigenvector-index VALUE corresponding eigenvalue
CoM   x-for-atom-i-of-vector y-for-atom-i-of-vector z-for-atom-i-of-vector
CoM   If modes are not provided, built-in zero-frequency ones are used.
CoM
CoM  *Coordinates must be in PDB format.
CoM   Only ATOM records are taken into account.
CoM
CoM---------------------------------------------------------------------
CoM   Since version 1.41:
CoM   If vectors were calculated for a set of separated bodies (with no
CoM   interaction), the difference-vector can be buildt from two
CoM   files with the coordinates of a single of these bodies.
CoM
CoM   Also, in this case, vectors are annotated: 
CoM  "A" for motions of the largest body, "B" for motions of other ones.
CoM--------------------------------------------------------------------- 
      program Projmod
      implicit none
      integer nvecmx, natmax, nresmx
CoM
CoM   This is a fortran 77 program (sorry), so it has predefined:
CoM   ==============
CoM   MEMORY LIMITS:
CoM   ==============
CoM   Increase them if needed, that is, if the program complains or
CoM   if you are studying (too) large systems. 
CoM
c     NATMAX: Maximum number of atoms.
c     NRESMX: Maximum number of amino-acid residues.
c     NVECMX: Maximum number of vectors.
    
      parameter( natmax =  5000 ,
     .           nvecmx =  5000 ,
     .           nresmx =  natmax )
CoM   
CoM   To (re)compile this program, type:
CoM   make proj_modes
CoM   or:
CoM   gfortran -o proj_modes proj_modes.f
CoM   or use your favorite fortran compiler instead (of gfortran).
CoM   To run it in the current directory, type: ./proj_modes
c----------------------------------------------------------------------- 
      integer lnomfmx, nmotsmax
      parameter(lnomfmx=128,nmotsmax=128)
      integer atind(natmax), fatres(nresmx+1), fatresc(nresmx+1),
     .        iat, ibigz, imax, iord(nvecmx), ires, iresat(natmax), 
     .        iresatc(natmax), ish, ivec, 
     .        jat, jmax, jres, jrs2, kat, lat, 
     .        lmot, lnomeig, lnompdb, lnompdbc, lnompdbr, mdmax, 
     .        natom, natomc, natomeff, natvec, ncontrt, nddl, nddleff, 
     .        nidem, nmass, nmax, nmots, noff, nok, npk, nres, 
     .        nresc, nrot, nrotfil, nssu, nssuc, nsum, numvec(nvecmx), 
     .        nunit, nvec, nveceff, nvecotr, nzero, 
     .        prtlev, ridshift,
     .        uncfx, uneig, unmor, unout, unpdb, unpdbc, unpdbr,
     .        i, ii, j, jj, k
      double precision avemass, bigzero, dq, dr, dr2, 
     .       eigrt(3*natmax,6), entr,
     .       freq(nvecmx), freqs(nvecmx), gap, lowfreq, 
     .       massat(natmax), masstot, matvec(3*natmax,nvecmx), 
     .       ndreff, norme, probi, 
     .       qcos, qdiff, qnorm, qp, qproj, qsum, qtot(nvecmx), 
     .       q2tot(nvecmx), 
     .       rec(6,6), recmax, rmsat, rmsmass, 
     .       small, small2, smasse(natmax), 
     .       tot, totall, totz,
     .       w(nvecmx), wmain(natmax), wtofreq,
     .       xat(natmax), xcm, xconf(natmax), xcurr(natmax),
     .       xref(natmax),
     .       yat(natmax), ycm, yconf(natmax), ycurr(natmax),
     .       yref(natmax),
     .       zat(natmax), zcm, zconf(natmax), zcurr(natmax),
     .       zref(natmax)
      logical qbig, qblock(natmax), qerror, qexist, qinter, qlin, 
     .       qmasse, qok, qpb, qrep, qseg, qsegc, qselat(natmax), 
     .       qselc(natmax), qselvec(nvecmx), qsort, qssu, qsubs, 
     .       qvecrt(nvecmx), qzerof
      character atonam(natmax)*4, atonamc(natmax)*4, cformat*12, 
     .       codpdb*4, cstatus*12, mots(nmotsmax)*(lnomfmx), 
     .       namfil*(lnomfmx), nom*7, nomb*1, nomeig*(lnomfmx), 
     .       nompdb*(lnomfmx), nompdbc*(lnomfmx), nompdbr*(lnomfmx), 
     .       prognam*9, progrer*12, progrwn*12, 
     .       resnam(natmax)*4, resnamc(natmax)*4, 
     .       segid(natmax)*4, segidc(natmax)*4, ssunam(natmax)*1, 
     .       ssunamc(natmax)*1, ssusel*1, version*40
CoM---------------------------------------------------------------------
CoM   In case of problem(s), feel free to tell:
CoM   Yves-Henri.Sanejouand@univ-nantes.fr (bug reports may help others).
CoM---------------------------------------------------------------------
CoM   This software is released under the CeCILL FREE SOFTWARE LICENSE.
CoM   In short: this license is compatible with the GNU GPL.
CoM   Specifically: it grants users the right to modify and redistribute 
CoM   this software within the framework of an open source distribution 
CoM   model. The complete text of the license can be found there:
CoM   http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
CoM-----------------------------------------------------------------------
c     YHS-Fev-1997: v1.00 (Toulouse).
c....................................................................... 
      version=' Version 1.78, March 2017.' 
c....................................................................... 
      nom='Projmod'
      prognam=' '//nom//'>'

      write(6,'(2A)') prognam,
     .    ' Projection of a difference vector'//
     .    ' on a set of eigenvectors.'
      write(6,'(2A/)') prognam,version

cDefaults:
      progrwn='%'//nom//'-Wn>'
      progrer='%'//nom//'-Er>'
      qzerof=.false.
      qsort=.false.
      small2=1e-8
      small=1e-4
c     Charmm units:
      wtofreq=108.586698

      prtlev=1

c     Ouverture des fichiers:
c     ----------------------
c     En lecture:
      nunit=10

      call getnam(
     .    'Name of the file with the (eigen)vectors ? (or NONE)',
     .     nomeig,lnomeig,qok)
      if (.not.qok) stop

      cformat="FORMATTED"
      cstatus="old"

      call noname(nomeig,lnomeig,qok)
      if (nomeig.eq.'NONE') then
      uneig=-1
      else
      uneig=nunit
      nunit=nunit+1
      call openam(nomeig,lnomeig,cformat,cstatus,uneig,.true.,
     .            qinter,qexist)
      if (qinter.or..not.qexist) stop
c     No risk taken.
      if (lnomeig.eq.lnomfmx) stop '*Filename is too long*'
      endif
 
c     On recherche l'information/sous-unite:
c     Structure de reference:
 
      call getnam('Pdb file with the reference coordinates ?',
     .     nompdbr,lnompdbr,qok)
      if (.not.qok) stop
c     No risk taken.
      if (lnompdb.eq.lnomfmx) stop '*Filename is too long*'
 
      nompdb=nompdbr
      lnompdb=lnompdbr
 
      call string_split(nompdb,lnompdb,':',
     .                  mots,nmotsmax,nmots)
      call stringcl(mots(1),lmot)
 
      if (nmots.gt.1) then
          call stringcl(mots(2),lmot)
          ssusel=mots(nmots)
          write(6,*) 'Pdbsel> Subunit to be selected: ',ssusel
          if (nmots.gt.2) then
              write(6,'(4A)') progrwn,
     .      ' The end of pdb name, ',
     .        nompdb(1:lnompdb),', was not understood.'
          endif
      else
          ssusel=' '
      endif
      nompdb=mots(1)
 
      unpdb=nunit
      nunit=nunit+1
      call openam(nompdb,lnompdb,cformat,cstatus,unpdb,.true.,
     .            qinter,qexist)
      if (qinter.or..not.qexist) stop
      unpdbr=unpdb
 
c     Autre conformere (eventuel):
 
      call getnam('Pdb file with the other conformer ? (if any) ',
     .     nompdbc,lnompdbc,qok)
      if (.not.qok) stop
c     No risk taken.
      if (lnompdb.eq.lnomfmx) stop '*Filename is too long*'
 
      nompdb=nompdbc
      lnompdb=lnompdbc
 
      call string_split(nompdb,lnompdb,':',
     .                  mots,nmotsmax,nmots)
      call stringcl(mots(1),lmot)
 
      if (nmots.gt.1) then
          call stringcl(mots(2),lmot)
          ssusel=mots(nmots)
          write(6,*) 'Pdbsel> Subunit to be selected: ',ssusel
          if (nmots.gt.2) then
              write(6,'(4A)') progrwn,
     .      ' The end of pdb name, ',
     .        nompdb(1:lnompdb),', was not understood.'
          endif
      else
          ssusel=' '
      endif
      nompdb=mots(1)
 
      unpdbc=-1
      inquire(file=nompdb,exist=qexist)

      if (qexist) then
      unpdb=nunit
      nunit=nunit+1
      call openam(nompdb,lnompdb,cformat,cstatus,unpdb,.true.,
     .            qinter,qexist)
      if (qinter) stop
      unpdbc=unpdb
      else
      write(6,'(2A)') progrwn,' Other conformer not found.'
      endif
 
      call getrep(
     .   ' Are the masses given in the pdb file ? (y/n)',
     .     qmasse,qok)
      if (.not.qok) qmasse=.false.
 
      if (qmasse) then
          write(6,'(/2A)') prognam,
     .  ' Masses will be picked in the pdb files.'
      else
          write(6,'(/2A)') prognam,
     .  ' All masses will all be assumed to be of 1.'
      endif
 
      call getrep(
     .    'Get rid of zero-frequency modes ? (y/n)',
     .     qzerof,qok)
      if (.not.qok) qzerof=.false.
 
      call getrep(
     .    'Sort mode contributions to the motion ? (y/n)',
     .     qsort,qok)
      if (.not.qok) qsort=.false.
 
      call getrep('CHARMM units ? (y/n)',qrep,qok)
      if (.not.qrep) wtofreq=1.d0/(2.0*dacos(-1.d0))

c     Lecture des fichiers:
c     =====================
      qpb=.false.

c     Les coordonnees:
c     ----------------
      write(6,'(/2A)') prognam,' First (reference) structure:'

      call rdatompdb(unpdbr,ssusel,.false.,xref,yref,zref,massat,
     .     atonam,iresat,resnam,ssunam,segid,natmax,natom,
     .     fatres,nresmx,nres,codpdb,qerror,prtlev)

      call segidtossu(segid,natom,.false.,qseg,ssunam,nssu,prtlev)
      if (qseg) 
     .    write(6,'(2A)') prognam,
     .  ' Charmm-like PDB file (with segment names).'
      if (nssu.gt.1) then
          write(6,'(A,I6,A)') prognam,nssu,' different chains.'
      else
          write(6,'(A,I6,A)') prognam,nssu,' chain.'
      endif

      nmass=0
      if (qmasse) then
      do i=1,natom
      if (massat(i).le.0) then
         nmass=nmass+1
         qselat(i)=.false.
      endif
      enddo
      if (nmass.gt.0)
     .   write(6,'(/A,I6,A)') progrwn,nmass,
     . ' null or negative atomic masses read in PDB file.'
      else
      do i=1,natom
         massat(i)=1.d0
      enddo
      endif

c     System rotation-translation vectors are built:
      
      masstot=0.0
      xcm=0.d0
      ycm=0.d0
      zcm=0.d0
      do i=1,natom
         xcm=xcm + massat(i)*xref(i)
         ycm=ycm + massat(i)*yref(i)
         zcm=zcm + massat(i)*zref(i)
         masstot=masstot+massat(i)
      enddo
      xcm=xcm/masstot 
      ycm=ycm/masstot 
      zcm=zcm/masstot 

      do i=1,6
      do j=1,3*natom
         eigrt(j,i)=0.d0
      enddo
      enddo

c     They are mass-weighted (like for normal-mode analysis).
      qlin=.true.
      do i=1,natom
         smasse(i)=dsqrt(massat(i))
c        Vecteurs de translation:
         eigrt(3*i-2,1)= smasse(i)
         eigrt(3*i-1,2)= smasse(i)
         eigrt(3*i,3)  = smasse(i)
c        Vecteurs de rotation:
         eigrt(3*i-2,4)= smasse(i)*(zref(i)-zcm)
         eigrt(3*i,4)  =-smasse(i)*(xref(i)-xcm)
         eigrt(3*i-1,5)= smasse(i)*(xref(i)-xcm)
         eigrt(3*i-2,5)=-smasse(i)*(yref(i)-ycm)
         eigrt(3*i,6)  = smasse(i)*(yref(i)-ycm)
         eigrt(3*i-1,6)=-smasse(i)*(zref(i)-zcm)
ChEcK    Systeme lineaire ? Doit etre aligne/axe des x.
         if (dabs(yref(i)-ycm).gt.small.or.
     .       dabs(zref(i)-zcm).gt.small) qlin=.false.
      enddo
c     And orthogonalized:
      if (qlin) then
         nrot=5
      else
         nrot=6
      endif
      call schmidt(3*natom,3*natmax,nrot,nrot,rec,eigrt,prtlev)

      if (uneig.gt.0) then
      nvec=min(nvecmx,3*natom)
      call rdmodfacs(uneig,3*natmax,nvec,numvec,freq,matvec,nddl)
 
      natvec=nddl/3
      if (natvec.gt.0.and.natvec.le.natmax.and.nvec.gt.0.and.
     .    nvec.le.nvecmx) then
      write(6,'(/A,I5,A,I6,A)') prognam, 
     .      nvec,' vectors, ',natvec,' atoms picked in vector file.'
      else
      write(6,'(/A,I5,A,I6,A)') prognam, 
     .      nvec,' vectors, ',natvec,' atoms in vector file.'
      stop '*Bug*'
      endif
      
c     Annotation des vecteurs.
c     ------------------------
c     On suppose que le premier vecteur est representatif.
CheK  A quel point sont-ils nuls ? 

      qbig=.false.
      nzero=0
      do j=1,nddl,3
         jj=(j+2)/3
         qblock(jj)=.false.
         if (dabs(matvec(j,1)).le.small2.and.
     .       dabs(matvec(j+1,1)).le.small2.and.
     .       dabs(matvec(j+2,1)).le.small2) then
             qblock(jj)=.true.
             nzero=nzero+1
             if (nzero.eq.1)
     .       write(6,'(/2A,I6,A)') progrwn,' Atom ',(j+2)/3,
     .     ' is not involved at all in mode one.'
         endif
      enddo

      if (nzero.gt.0) then
          write(6,'(2A)') prognam,' Several separated bodies.'

c         Le bloc avec le plus de zeros sera le bloc 'A':
          if (nzero.gt.natvec/2) then
              write(6,'(A,I6,A)') 
     .              prognam,nzero,' atoms in the largest one.'
              qbig=.true.
          else
              write(6,'(A,I6,A)') 
     .        prognam,natvec-nzero,' atoms in the largest one.'
          endif
      else
          write(6,'(/2A)') prognam,' Single body modes.'
      endif
      
c     Rotation-translation vector identification:
      do ivec=1,nvec
         qvecrt(ivec)=.false.
      enddo
      ncontrt=0
      nrotfil=0

      if (nzero.gt.0) then
         write(6,'(/2A)') progrwn,
     . ' Several bodies. '//
     .  'Zero-frequency modes are ignored.'
      else  
      do ivec=1,nvec
      qvecrt(ivec)=.false.
      qsum=0.d0
      do j=1,nrot
      qproj=0.0
      do i=1,nddl
         qproj=qproj+matvec(i,ivec)*eigrt(i,j)
      enddo
      qsum=qsum+qproj**2
      enddo
      if (qsum.gt.0.95) then
         nrotfil=nrotfil+1
         qvecrt(ivec)=.true.
         write(6,'(2A,I5,A)') prognam,' Vector ',ivec,
     . ' is an overall rotation-translation vector.'
      elseif (qsum.gt.0.10) then
         ncontrt=ncontrt+1
         write(6,'(2A,I5,A,F6.1,A)') progrwn,' Vector ',ivec,
     . ' has a rotation-translation contribution of ',qsum*100.0,'%'
      endif
      enddo
      write(6,'(A,I5,A)') prognam, 
     .      nrotfil,' overall rotation-translation vectors.'
      if (ncontrt.gt.0)
     .write(6,'(A,I5,A)') progrwn, 
     .      ncontrt,' vectors are contaminated by rotation-translation.'
      endif

c     Rotation-translation vectors are the only ones:
      else
      nvec=nrot
      write(6,'(/2A)') prognam,
     .' No mode vector provided but zero-frequency ones are available.'
      do ivec=1,nvec
      do i=1,3*natom
         matvec(i,ivec)=eigrt(i,ivec)
      enddo
      if (ivec.le.3) then
         write(6,'(2A,I5,A)') prognam,' Vector ',ivec,
     . ' is an overall translation vector.'
      else
         write(6,'(2A,I5,A)') prognam,' Vector ',ivec,
     . ' is an overall rotation vector.'
      endif
      qvecrt(ivec)=.true.
      freq(ivec)=0.0
      enddo
      nrotfil=nvec
      natvec=natom
      nddl=3*natom
      ncontrt=0
      nzero=0
      endif

c     Tests:
c     ------
      qsubs=.false.
      if (natvec.eq.natom.or.
     .   (nzero.gt.0.and.(nzero.eq.natom.or.natvec-nzero.eq.natom)))then

          write(6,'(/2A)') prognam,
     .  ' Cartesian (eigen)vectors will be studied.'

          if (natvec.eq.natom) then
              do i=1,natom
                 atind(i)=i
              enddo
          else
              write(6,'(2A)') prognam,
     .      ' Motion of a part of the system will be considered.'
              qsubs=.true.
              if (nzero.ne.natom) then
                  do i=1,natvec
                     if (qblock(i)) then
                         qblock(i)=.false.
                     else
                         qblock(i)=.true.
                     endif
                  enddo
              endif
              ii=0
              do i=1,nddl
                 if (qblock(i)) then
                     ii=ii+1
                     atind(ii)=i
                 endif
              enddo
          endif
      else if (natvec.gt.0) then
          write(6,'(/2A)') progrer,
     .  ' Vector and reference pdb file are not consistent.'
          stop '*Wrong files*'
      else if (nddl.le.0.or.nvec.le.0) then
          write(6,'(/2A)') progrer,
     .  ' Nothing can be done.'
          stop '*Wrong files*'
      endif

c     Gap le plus important:
      call trier(freq,nvec,nvecmx,freqs,iord,.true.)

      bigzero=freqs(1)
      do i=1,nvec
      ivec=iord(i)
      if (qvecrt(ivec).and.freqs(ivec).gt.bigzero) then
         bigzero=freqs(ivec) 
         ibigz=i
      endif
      enddo 

      if (nvec.gt.ibigz) then
      do i=ibigz+1,nvec
      ivec=iord(i)
      if (.not.qvecrt(ivec)) then
         lowfreq=freqs(ivec)
         goto 50
      endif     
      enddo
      lowfreq=bigzero
  50  continue
      else
         lowfreq=bigzero
      endif
      gap=lowfreq-bigzero

      write(6,'(2A,F13.8)') prognam,
     .' Lowest non-zero eigenvalue : ',lowfreq
      if (nrotfil.gt.0.and.nvec.gt.nrotfil) then
        write(6,'(2A,F13.8)') prognam,
     .' Eigenvalue gap after zeroes: ',gap
      if (ibigz.gt.0) 
     .write(6,'(A,I5,A,F13.8)') prognam,ibigz,
     . ' frequencies less than : ',wtofreq*dsqrt(bigzero)+small2
      if (ibigz.ne.nrotfil) then
         write(6,'(/A,I5,A)') progrwn,nrotfil,
     . ' expected: system was not energy-minimized ?'//
     . ' Non-consistent masses ?'
         qpb=.true.
      endif
      endif

      if (qzerof) then
          write(6,'(/2A)') prognam,
     .  ' Zero-frequency modes will be skipped.'
      else
          write(6,'(/2A)') prognam,
     .  ' Zero-frequency modes will be taken into account.'
      endif
CoM
CoM   When a single conformer is provided, it is assumed to be a difference vector.

      do i=1,natom
         qselat(i)=.true.
      enddo

      if (unpdbc.le.0) then
          write(6,'(/2A)') progrwn,' One conformer only !!!'
          write(6,'(2A)') progrwn,
     .  ' It is assumed to be a difference-vector...'
          do i=1,natom
             xat(i)=xref(i)
             yat(i)=yref(i)
             zat(i)=zref(i)
          enddo
          goto 200
      endif

      write(6,'(/2A)') prognam,' Second structure (conformer):'

      call rdatompdb(unpdbc,ssusel,.false.,xconf,yconf,zconf,wmain,
     .     atonamc,iresatc,resnamc,ssunamc,segidc,natmax,natomc,
     .     fatresc,nresmx,nresc,codpdb,qerror,prtlev)

      call segidtossu(segidc,natom,.false.,qsegc,ssunamc,nssuc,prtlev)
      if (qsegc) 
     .    write(6,'(2A)') prognam,
     .  ' Charmm-like PDB file (with segment names).'

      if (nssuc.eq.nssu) then
         write(6,'(2A)') prognam,' Same number of chain(s).'
      elseif (nssuc.lt.nssu) then
         write(6,'(A,I6,A)') progrwn,nssuc,' different chain(s) (only).'
      else
         write(6,'(A,I6,A)') progrwn,nssuc,
     . ' different chains (too much).'
      endif

c     Conformite des deux conformeres consideres:

      if (natomc.ne.natom) then
          write(6,'(/2A)') progrwn,
     .  ' Different number of atoms for the other conformer.'
      endif
      if (nresc.ne.nres) then
          write(6,'(/2A)') progrwn,
     .  ' Different number of residues for the other conformer.'
      endif

c     Is there a shift of the residue identifiers ?

      nmax=0
      do ires=1,nres
      iat=fatres(ires)
      do jres=1,nresc
         jat=fatresc(jres)
         if (resnamc(jat).eq.resnam(iat)) goto 55
      enddo
 55   continue
      nidem=1
      if (nresc.gt.jres) then
      ish=0
      do jrs2=jres+1,nresc
         ish=ish+1
         kat=fatres(ires+ish)
         lat=fatresc(jrs2)
         if (resnamc(lat).ne.resnam(kat)) goto 60
         nidem=nidem+1
      enddo
      endif
 60   continue
      if (nidem.gt.nmax) then
          nmax=nidem
          ridshift=iresatc(jat)-iresat(iat)
      endif
      enddo
      if (ridshift.ne.0) 
     .write(6,'(2A,I6)') progrwn,' Residue identifiers are shifted by ',
     .ridshift

c     Same kind of PDB (standard, charmm,...):
      if (nssu.gt.1.or.nssuc.gt.1) then
          qssu=.true.
      else
          qssu=.false.
      endif
      noff=0
      nok=0
      if ((qseg.and.qsegc).or.
     .   (.not.qseg.and..not.qsegc).or..not.qssu) then
      do i=1,natom
         qselc(i)=.false.
      enddo
      do i=1,natom
         do j=1,natomc
         if (iresatc(j).eq.iresat(i)+ridshift) then
         if (atonamc(j).eq.atonam(i).and.resnamc(j).eq.resnam(i).and.
     .      (.not.qssu.or.ssunamc(j).eq.ssunam(i))) then
             xcurr(i)=xconf(j) 
             ycurr(i)=yconf(j) 
             zcurr(i)=zconf(j) 
             nok=nok+1
             if (nok.le.5) then
             if (prtlev.gt.0) 
     .       write(6,'(2A,I6,2A,I6,A,1X,2A)') prognam,
     .     ' Atom ',i,' of first conformer: ',resnam(i),iresat(i),
     .       ssunam(i),atonam(i),' found in second one.'
             elseif (nok.eq.5) then
             write(6,'(2A)') progrwn,' ...'
             endif
             if (qselc(j)) then 
                 write(6,'(2A,I6,2A,I6,A,1X,2A)') progrwn,
     .         ' Atom ',i,' of first conformer: ',resnam(i),iresat(i),
     .           ssunam(i),atonam(i),' found twice.'
             else
                 qselc(j)=.true.
             endif 
             goto 100
         elseif (atonamc(j).eq.atonam(i).and.
     .      (.not.qssu.or.ssunamc(j).eq.ssunam(i))) then
             xcurr(i)=xconf(j) 
             ycurr(i)=yconf(j) 
             zcurr(i)=zconf(j) 
             npk=npk+1
             if (npk.le.5) then
             write(6,'(2A,I6,2A,I6,A,1X,2A,1X,A)') progrwn,
     .     ' Atom ',i,' of first conformer: ',resnam(i),iresat(i),
     .       ssunam(i),atonam(i),' found in second one, but in residue',
     .       resnamc(j)
             elseif (nok.eq.5) then
             write(6,'(2A)') progrwn,' ...'
             endif
             if (qselc(j)) then 
                 write(6,'(2A,I6,2A,I6,A,1X,2A,1X,A)') progrwn,
     .         ' Atom ',i,' of first conformer: ',resnam(i),iresat(i),
     .           ssunam(i),atonam(i),' found twice, in residue',
     .           resnamc(j)
             else
                 qselc(j)=.true.
             endif
             goto 100
         endif
         endif
         enddo
         qselat(i)=.false.
         noff=noff+1
         if (noff.lt.10) then
         write(6,'(2A,I6,2A,I6,A,1X,2A)') progrwn,
     . ' Atom ',i,' of first conformer: ',resnam(i),iresat(i),
     .   ssunam(i),atonam(i),' not found in second one.'
         elseif (noff.eq.10) then
         write(6,'(2A)') progrwn,' ...'
         endif
 100     continue
      enddo      
      do i=1,natom
         xconf(i)=xcurr(i) 
         yconf(i)=ycurr(i) 
         zconf(i)=zcurr(i) 
         atonamc(i)=atonam(i)
         resnamc(i)=resnam(i)
         iresatc(i)=iresat(i)
      enddo
c     Different kinds of PDB must have atoms in same order:
      else
      do i=1,natom
         if (iresatc(i).eq.iresat(i)+ridshift.and.
     .       atonamc(i).eq.atonam(i).and.
     .       resnamc(i).eq.resnam(i)) then
             nok=nok+1
         else
             noff=noff+1
             if (noff.lt.10) then
             write(6,'(2A,I6,2A,I6,A,1X,2A,I6,A)') progrwn,
     .     ' Atom ',i,' of first conformer: ',resnam(i),iresat(i),
     .       ssunam(i),atonam(i),' differs from atom ',
     .       i,' of second conformer.'
             elseif (noff.eq.10) then
             write(6,'(2A)') progrwn,' ...'
             endif
             qselat(i)=.false.
         endif
      enddo
      if (natom.gt.natomc) then
      do i=natomc+1,natom
         qselat(i)=.false.
      enddo
      endif   
      endif

      if (noff.gt.0) write(6,'(A,I6,A)') 
     .    progrwn,noff,' atoms not found in other conformer.'
      if (npk.gt.0) write(6,'(A,I6,A)') progrwn,npk,
     .  ' atoms found in other conformer, but in a different residue.'
      if (nok.eq.0) then
         write(6,'(/3A)') progrer,' No common atom ? (required)'
         stop '*Wrong set of conformers*'
      elseif (dfloat(nok)/dfloat(natom).lt.0.5) then
         write(6,'(/2A)') progrwn,
     . ' Sure it is meaningful to do this projection ?' 
         qpb=.true.
      endif

c     Vecteur difference:
c     ------------------
      do i=1,natom
      if (qselat(i)) then
         xat(i)=xconf(i)-xref(i)
         yat(i)=yconf(i)-yref(i)
         zat(i)=zconf(i)-zref(i)
      endif
      enddo      

 200  continue
      write(6,'(/2A)') prognam,
     . ' File dr.res: displacement=f(atom number).'

      cformat="FORMATTED"
      cstatus="ove"
      namfil='dr.res'
      call stringcl(namfil,lmot)
      unmor=nunit
      nunit=nunit+1
      cstatus="ove"
      call openam(namfil,lmot,cformat,cstatus,unmor,.true.,
     .            qinter,qexist)

      avemass=0.d0
      rmsmass=0.d0
      natomeff=0
      rmsat=0.d0

      do i=1,natom
         dr2=0.d0
         if (qselat(i)) then
             avemass=avemass+massat(i)
             rmsmass=rmsmass+massat(i)**2.d0
             dr2=xat(i)**2.d0+yat(i)**2.d0+zat(i)**2.d0
             rmsat=rmsat+dr2
             natomeff=natomeff+1
             write(unmor,'(I6,F12.4)') i,dsqrt(dr2)
         endif
      enddo
      avemass=avemass/float(natomeff)
      rmsmass=dsqrt(rmsmass/float(natomeff)-avemass**2.d0)
      rmsat=dsqrt(rmsat)
 
      nddleff=3*natomeff
      write(6,'(A,I6,A)') prognam,natomeff,' atoms are considered.'
      write(6,'(A,F6.1,A)') prognam,
     .      dfloat(100*(natom-noff-npk))/dfloat(natom),
     .     '% of atoms of first conformer have been retained.'

      write(6,'(/2A,F8.2)') prognam,
     .    ' Atomic r.m.s. displacements=  ',
     .      rmsat/sqrt(float(natomeff))
      write(6,'(A,2(A,F8.2))') prognam,
     .    ' Atomic average masses      =  ',avemass,' +/- ',rmsmass
 
      norme=0.d0
      do i=1,natom
         if (qselat(i)) 
     .   norme=norme+
     .  (xat(i)**2.d0+yat(i)**2.d0+zat(i)**2.d0)*massat(i)
      enddo
      if (norme.le.small) then
         write(6,'(2A,I6,A)') progrer,
     . ' Difference-vector has null norm. Projection skipped.'
         goto 900
      endif

      if (norme.le.small) then
          write(6,'(/2A)') progrer,' Null difference vector.'
          stop '*No motion*'
      endif

      ndreff=0.d0
      do i=1,natom
      if (qselat(i)) then
         probi=(xat(i)**2.d0+yat(i)**2.d0+zat(i)**2.d0)*massat(i)/norme
         if (probi.gt.0.d0) ndreff=ndreff-probi*log(probi)
      endif
      enddo
      ndreff=exp(ndreff)
      norme=dsqrt(norme)

      if (dabs(norme-rmsat).gt.small)
     .    write(6,'(2A,F8.2)') prognam,
     .  ' Atomic mass-weighted rmsd  =  ',
     .    norme/sqrt(float(natomeff))

      write(6,'(2A,F8.2,A)') prognam,
     .  ' Effect. nb of moving atoms =  ',
     .    100.0*ndreff/dfloat(natomeff),'%'

c     Projection mode par mode:
c     =========================
CoM
CoM   The overlap is the absolute scalar product of the
CoM   displacement vector and the mode vector.
CoM   Because the mode vector direction is meaningless,
CoM   the sign of this scalar product is also meaningless.
CoM
CoM   The square of the overlap gives the amount
CoM   of contribution of the mode to the displacement,
CoM   since the cumulative square overlap for all modes is 1. 

      write(6,'(/2A)') prognam,' File projmod.res:'//
     .    ' dr.vector=f(fqcy), and cumulative square sum.'
      
      cformat="FORMATTED"
      cstatus="ove"
      namfil='projmod.res'
      call stringcl(namfil,lmot)
      unout=nunit
      nunit=nunit+1
      call openam(namfil,lmot,cformat,cstatus,unout,.true.,
     .     qinter,qexist)
      write(unout,'(A)') 
     .   '  Mode      Frequency   Overlap   Cumulative (%)  q  '

      recmax=0.d0
      nvecotr=0
      totz=0.d0
      tot=0.d0
      mdmax=-1
 
      do ivec=1,nvec
         qnorm=0.d0
         qproj=0.d0
         do i=1,natom
          if (qselat(i)) then
            ii=3*atind(i)-2
            qp=matvec(ii,ivec)*xat(i)*dsqrt(massat(i))+
     .         matvec(ii+1,ivec)*yat(i)*dsqrt(massat(i))+
     .         matvec(ii+2,ivec)*zat(i)*dsqrt(massat(i))
            qproj=qproj+qp
            qnorm=qnorm+
     .         matvec(ii,ivec)**2.d0+
     .         matvec(ii+1,ivec)**2.d0+
     .         matvec(ii+2,ivec)**2.d0
          endif
         enddo
 
c        Cosinus:
c        -------
         if (qnorm.le.small) then
             if (qsubs) then
                 nvecotr=nvecotr+1
             else
                 write(6,'(2A,I6,A)') progrwn,' Eigenvector ',ivec,
     .         ' has null norm. It is skipped.'
             endif
             goto 400
         endif
         if ((natom.eq.natomeff.and.dabs(qnorm-1.).gt.small).or.
     .       qnorm-1.gt.small) then
             write(6,'(2A,I6,A,F12.4)') progrwn,' Eigenvector ',ivec,
     .           ' Norm= ',qnorm
         endif

         qnorm=dsqrt(qnorm)
         qdiff=qproj/qnorm
         qcos =qproj/(norme*qnorm)
         qcos=dabs(qcos)

         if (qcos.gt.recmax) then
             recmax=qcos
             mdmax=ivec
         endif

c        Somme cumulee des cosinus-carres:
c        ---------------------------------

         q2tot(ivec)=0.d0
         qtot(ivec)=0.d0
         if (qvecrt(ivec)) totz=totz+qcos**2.d0 

         if (.not.(qzerof.and.qvecrt(ivec))) then
             q2tot(ivec)=qcos**2.d0
             tot=tot+q2tot(ivec)
             qtot(ivec)=qdiff
         endif

c        Type de vecteur:
c        ----------------

         nomb='A'
         if (nzero.gt.0) then
         k=0
         do j=1,3*natom,3
            jj=(j+2)/3
            if (matvec(j,ivec).eq.0.d0.and.matvec(j+1,ivec).eq.0.d0.and.
     .          matvec(j+2,ivec).eq.0.d0.and.qblock(jj)) k=k+1
         enddo
         if (k.eq.nzero) then
         if (qbig) then
             nomb='A'
         else
             nomb='B'
         endif
         endif
         endif

         if (.not.(qzerof.and.qvecrt(ivec))) then
             write(6,'(A,I6,1X,2A,F12.4,2(4X,A,F6.3),A,F12.4)') 
     .     ' Vector: ',ivec,nomb,' F= ',
     .       dsign(wtofreq*dsqrt(dabs(freq(ivec))),freq(ivec)),
     .     ' Cos= ',qcos,' Sum= ',tot,
     .     ' q= ',qdiff
             write(unout,'(I6,1X,A,1X,F12.6,F12.4,F8.2,F12.4)') 
     .       ivec,nomb,
     .       dsign(wtofreq*dsqrt(dabs(freq(ivec))),freq(ivec)),
     .       qcos,100.d0*tot,qdiff
         endif

c        Vecteur suivant:
c        ----------------
 400     continue
      enddo
      close(unout)
 
      if (nvecotr.gt.0) 
     .   write(6,'(/A,I6,A)') prognam,nvecotr,
     . ' vectors skipped (they are not involved in subsystem motion).'

      write(6,'(/2A,F6.2,A,I6,A,F8.2,A)') prognam,
     .  ' Best overlap with diff.vect. =',recmax,' for mode ',mdmax,
     .'   with F= ',dsign(wtofreq*dsqrt(dabs(freq(mdmax))),freq(mdmax)),
     .  ' cm-1.'

      if (totz.gt.0.1) then
          write(6,'(/A,F8.2,A)') progrwn,100*totz,
     .   '% of the motion described with zero-frequency modes.'
          if (nrotfil.eq.6) then
          write(6,'(2A)') progrwn,
     .  ' Second conformer not fitted ? Non-consistent masses ?'
          qpb=.true.
          endif
      else
          write(6,'(/A,3X,F8.2,A)') prognam,100*totz,
     .   '% of the motion described with zero-frequency modes (fine).'
      endif

c     Tri des cosinus-carres par ordre decroissant:
c     ---------------------------------------------
c    (ou bien: on ecarte les contributions des modes nuls)

      if (qsort) then
          call trier(q2tot,nvec,nvecmx,w,iord,.false.)
      else
          do i=1,nvec
             w(i)=0.d0
          enddo
          ii=0
          do i=1,nvec
             iord(i)=i
             if (.not.(qzerof.and.qvecrt(ivec))) then
                 ii=ii+1
                 w(ii)=q2tot(i)
             endif
          enddo
      endif

c     Entropie de la description:
c     ---------------------------
c    (avec n modes consecutifs, pour pouvoir comparer d'un systeme a l'autre)
c     Sommation des contributions (somme des 3N=1):

      do ivec=1,nvec
         qselvec(ivec)=.false.
      enddo

      nveceff=min(nvec,56)
      if (qzerof.and.nveceff.gt.nrotfil) nveceff=nveceff-nrotfil

      do i=1,nvec
         ivec=iord(i)
         if (.not.(qzerof.and.qvecrt(ivec)).and.i.le.nveceff) 
     .   qselvec(ivec)=.true.
      enddo

      totall=0.d0
      ii=0
      do ivec=1,nvec
         totall=totall+w(ivec)
         if (qselvec(ivec)) tot=tot+w(ivec)
      enddo
      
      entr=0.d0
      nsum=0
      do ivec=1,nvec
      if (qselvec(ivec)) then
         probi=w(ivec)/tot
         if (probi.gt.0.d0) entr=entr-probi*log(probi)
         nsum=nsum+1
      endif
      enddo
      entr=exp(entr)

      if (nsum.gt.0) then
      if (qsort) then
      write(6,'(/2A,F5.2,A,I6,A)') prognam,
     . ' Effective nb of modes req.   = ',entr,
     . ' among the best ',nveceff,' ones.'
      else
      write(6,'(/2A,F5.2,A,I6,A)') prognam,
     . ' Effective nb of modes req.   = ',entr,
     . ' among the first ',nveceff,' ones.'
      endif
      else
      write(6,'(/2A)') progrwn,
     .' No vector can be considered for'//
     .' effective nb of modes calculation.'
      endif

c     Sortie cumulee:

      qsum=0.d0
      nsum=0
      do i=1,nvec
      ivec=iord(i)
      if (.not.qzerof.or..not.(qzerof.and.qvecrt(ivec))) then
         qsum=qsum+w(i)
         nsum=nsum+1
         q2tot(nsum)=qsum
      endif
      enddo

c     Sortie homogene (en colonnes):
c    -On sacrifie desormais a la coutume decimale...

      if (nsum.eq.0) then
          write(6,'(/2A)') progrwn,' No mode vector left.'
          goto 900
      elseif (nsum.lt.10) then
          write(6,'(/2A,I1,A)') progrwn,' Only ',nsum,' modes.'
          do i=nsum+1,10
             q2tot(i)=qsum
          enddo
      endif

      if (qsort) then
      write(6,'(/2A,6(F5.3,2X))')  prognam,
     . ' 1-3-6-9-10-all-best contrb.  = ',
     .   q2tot(1),q2tot(3),q2tot(6),q2tot(9),q2tot(10),qsum
      else
      write(6,'(/2A,6(F5.3,2X))')  prognam,
     . ' 1-3-6-9-10-all-first contrb. = ',
     .   q2tot(1),q2tot(3),q2tot(6),q2tot(9),q2tot(10),qsum
      endif
      
      write(6,'(/2A)') prognam,' Mode amplitudes are also saved.'
      
      cformat="FORMATTED"
      cstatus="ove"
      namfil='projmod.amplitudes'
      call stringcl(namfil,lmot)
      unout=nunit
      nunit=nunit+1
      call openam(namfil,lmot,cformat,cstatus,unout,.true.,
     .     qinter,qexist)
      write(unout,'(A)') '  Mode       q  '

      do i=1,nvec
         ivec=iord(i)
         write(unout,'(I6,F12.4)') ivec, qtot(ivec) 
      enddo 
      close(unout)

 900  continue
      if (qpb.or.ncontrt.gt.0)
     .    write(6,'(/2A)') progrwn,
     .  ' This projection may prove meaningless (check warnings above).'
      write(6,'(/2A)') prognam,' Normal end.'
 
      stop
      end
CoS=====================================================================
CoS...Schmidt: GRAM-SCHMIDT ORTHOGONALISATION of first M vectors.
CoS---------------------------------------------------------------------
c     INPUTS: 
c     -------
c     VECT(Nmax,*): Initial vectors.
c     M           : Number of vectors.
c     N           : Vector dimension.

c     OUTPUTS:
c     --------
c     REC(Mmax,) : Scalar product of the vectors.
c     VECT(Nmax,): Orthogonalized vectors.

c=======================================================================
c     Version 1.0: George Trinquier, 1993 (Toulouse).
c     Version 1.2: YHS-Sep-05 (Lyon).
c     Version 1.5: YHS-Jul-12.
c
      subroutine schmidt(N,Nmax,M,Mmax,rec,vect,prtlev)
      implicit none
cI/O:
      integer   M, Mmax, N, Nmax, prtlev
      double precision rec(Mmax,*), vect(Nmax,*)
cLocal:
      integer   i, j, k, lnomp
      parameter(lnomp=7)
      double precision aaa, anorm
      character nom*(lnomp), prognam*(lnomp+2), progrer*(lnomp+5),
     .          progrl2*(lnomp+5), progrwn*(lnomp+5)
cBegin:
      nom='Schmidt'
      prognam=' '//nom//'>'
      progrwn='%'//nom//'-Wn>'
      progrer='%'//nom//'-Er>'
      progrl2='%'//nom//'-L2>'
      if (prtlev.gt.1) write(6,'(2A)') progrl2,' Entering in.'

cCheck:
      if (N.le.0.or.M.le.0) then
          write(6,'(/2A)') progrer,' No valid vector on input.'
          stop '*Bug ?*'
      endif
 
      if (M.gt.Mmax) then
          write(6,'(2A,I6,A)') progrwn,' Only the first ',Mmax,
     .  ' vectors can be orthogonalized.'
          M=Mmax
c     Rien a faire:
      else if (M.eq.1) then
          return
      endif

c     Normalisation du premier vecteur:
      ANORM = 0.D0
      DO I=1,N
         ANORM = ANORM + vect(i,1)*vect(i,1)
      ENDDO
      ANORM = 1.D0 / ( DSQRT(ANORM) )
 
      DO I=1,N
         vect(i,1) = ANORM * vect(i,1)
      ENDDO
 
c     Produit scalaire du vecteur courant et des precedents: 
      DO  I=2,M      
       DO J=1,I-1
        REC(J,I) = 0.D0
        DO K=1,N
         REC(J,I) = REC(J,I) + vect(k,j)*vect(k,i)
        ENDDO
       ENDDO
       DO K=1,N
        AAA = 0.D0
        DO J=1,I-1
         AAA = AAA + vect(k,j)*REC(J,I)
        ENDDO
        vect(k,i) = vect(k,i) - AAA
       ENDDO

c      Normalisation du vecteur courant: 
       ANORM = 0.D0
       DO K=1,N
        ANORM = ANORM + vect(k,i)*vect(k,i)
       ENDDO 
       ANORM = 1.D0 / ( DSQRT(ANORM) )
 
       DO K=1,N
        vect(k,i) = ANORM*vect(k,i)
       ENDDO
      ENDDO

      if (prtlev.gt.1) write(6,'(2A)') progrl2,' Exiting.'
      RETURN
      END  
c-----------------------------------------------------------------------
      subroutine noname(nom,lnom,qok)
CoS=====================================================================
CoS...Noname: Checks if a string contains N, NO, NON, NONE.
CoS---------------------------------------------------------------------
CoS   Purpose   : To check if a filename was given on input,
CoS               NONE being the default.
CoS
CoS   Properties: Not case dependent.
CoS               If true, input is changed to NONE.

c     NOM : Input string to be checked.
c     LNOM: String length to be checked.
c     QOK : True if strings is N|NO|NON|NONE.

c     Uses: mintomaj.
c     Version 1.11: YHS-Apr-2014, Nantes.
CoS---------------------------------------------------------------------
c     Version 1.00: YHS-Nov-2013, Nantes.
cI/O:
      integer lnom
      logical qok
      character nom*(*)
cLocal:
      character*4 nomcur
cBegin:
      qok=.false.
      if (lnom.gt.4) return

      nomcur=nom
      call mintomaj(nomcur) 
      if (lnom.eq.4.and.nomcur.eq.'NONE') qok=.true.
      if (lnom.eq.3.and.nomcur.eq.'NON')  qok=.true.
      if (lnom.eq.2.and.nomcur.eq.'NO')   qok=.true.
      if (lnom.eq.1.and.nomcur.eq.'N')    qok=.true.

      if (qok) then
          nom='NONE'
          lnom=4
      endif
      return
      end
c-----------------------------------------------------------------------
      subroutine mintomaj(chaine)
 
c     Les caracteres minuscules sont mis en MAJUSCULES.
c     Les autres ne sont pas touches.
 
c     YHS-Oct-98: Premiere version (Toulouse).
c     YHS-Sep-03: Dernieres modifications (Lyon).
 
      character*(*) chaine
c Local:
      integer icar, ilettre, taille
      character*26  carmaj, carmin
 
      carmin='qwertyuiopasdfghjklzxcvbnm'
      carmaj='QWERTYUIOPASDFGHJKLZXCVBNM'
 
      taille=len(chaine)
      if (taille.le.0) return

      do icar=1,taille
         ilettre=index(carmin,chaine(icar:icar))
         if (ilettre.gt.0) then
             chaine(icar:icar)=carmaj(ilettre:ilettre)
         endif
      enddo
 
      return
      end
c-----------------------------------------------------------------------
      subroutine getnum(message,numlu,nummin,nummax,qok)
c
c     NUMLU obtenu en reponse au MESSAGE.
c     NUMLU doit etre inferieur a nummax et superieur a nummin.
c
c     NTRYMX essais en cas de probleme.
c     qok=.false. => Probleme a la lecture.
c
c     YHS-oct-1996: version 1.0
c     YHS-nov-2000: version 3.0
c
      implicit none
cI/O:
      integer numlu, nummax, nummin
      logical qok
      character*(*) message
cLocal:
      integer ntry, ntrymx, iread
cBegin:
      ntrymx=5
c
      qok=.false.
      ntry=0
c
 100  continue
      ntry=ntry+1
      if (ntry.ge.ntrymx) return
c
      write(6,'(A,A)') ' Getnum> ',message
      read(5,*,end=200,err=100) iread
      numlu=iread
c
      write(6,*) 'Getnum> ',numlu

      if (nummin.le.nummax) then
      if (numlu.gt.nummax) then
          write(6,'(A,I6,A)') 
     .  '%Getnum-Err: number larger than ',nummax,
     .  ' This is not allowed. Sorry.'
          numlu=nummax
          return
      else if (numlu.lt.nummin) then
          write(6,'(A,I6,A)') 
     .  '%Getnum-Err: number smaller than ',nummin,
     .  ' This is not allowed. Sorry.'
          numlu=nummin
          return
      endif
      endif
c
      qok=.true.
      return
 200  continue
      return
      end 
c-------------------------------------------
      subroutine getchi(message,numlu,qok)
c
c     NUMLU obtenu en reponse au MESSAGE.
c     NTRYMX essais en cas de probleme.
c     YHS-oct-96
c
      implicit none
cI/O:
      double precision numlu
      logical qok
      character*(*) message
cLocal:
      integer ntry, ntrymx
      double precision iread
cBegin:
      ntrymx=5
c
      qok=.false.
      ntry=0
c
 100  continue
      ntry=ntry+1
      if (ntry.ge.ntrymx) return
c
      write(6,'(A,A)') ' Getchi> ',message
      read(5,*,end=200,err=100) iread
      numlu=iread
c
      write(6,*) 'Getchi> ',numlu
c
      qok=.true.
      return
 200  continue
      return
      end 
c-----------------------------------------------------------------------
      subroutine getnam(message,nomlu,lnomlu,qok)
c
c     NOMLU obtenu en reponse au MESSAGE.
c     NTRYMX essais en cas de probleme.
c     YHS-oct-96
c
      implicit none
cI/O:
      integer lnomlu
      logical qok
      character*(*) message, nomlu
cLocal:
      integer ntry, ntrymx
cBegin:
      ntrymx=5
c
      qok=.false.
      ntry=0
c
 100  continue
      ntry=ntry+1
      if (ntry.ge.ntrymx) return
c
      write(6,'(A,A)') ' Getnam> ',message
      read(5,'(A)',end=200,err=100) nomlu
c
      call stringcl(nomlu,lnomlu)
      write(6,'(A,A)') ' Getnam> ',nomlu(1:lnomlu)
c
      qok=.true.
      return
 200  continue
      return
      end 
c---------------------------------------------------
      subroutine getrep(message,qinfo,qok)
c
c     qinfo obtenu en reponse au MESSAGE.
c     NTRYMX essais en cas de probleme.
c     YHS-jan-00
c     YHS-oct-00
c
      implicit none
cI/O:
      logical qok, qinfo
      character*(*) message
cLocal:
      integer ntry, ntrymx
      character*1 cread
cBegin:
      ntrymx=2
c
      qinfo=.false.
      qok=.false.
      ntry=0
c
 100  continue
      ntry=ntry+1
      if (ntry.ge.ntrymx) then
          goto 200
          return
      endif
c
      write(6,'(A,A)') ' Getrep> ',message
      read(5,'(A)',end=200,err=100) cread
c
      if (cread.eq.'T'.or.cread.eq.'t'.or.
     .    cread.eq.'Y'.or.cread.eq.'y'.or.
     .    cread.eq.'O'.or.cread.eq.'o') then
          qinfo=.true.
      else
      if (cread.ne.'F'.and.cread.ne.'f'.and.
     .    cread.ne.'N'.and.cread.ne.'n')
     .    write(6,'(3A)') '%Getrep-W> Unexpected answer:',cread,
     . '. Assumed answer is: NO.'
      endif
c
      write(6,*) 'Getrep> ',qinfo
c
      qok=.true.
      return
 200  continue
      write(6,'(A)') '%Getrep-W> No answer.'//
     .    ' Assumed answer is: NO.'
      return
      end 
c-----------------------------------------------------------------------
      subroutine openam(namfil,lnom,cformat,cstatus,unit,qverbos,
     .                  qinterr,qexist)
c======================================================================= 

c     Ouverture d'un fichier de nom NAMFIL, sur l'unite UNIT.
 
c======================================================================= 
c     input:
c        namfil: nom du fichier a ouvrir. 
c        lnom: longueur de ce nom.
c       "stop", "end", "fin", "quit" : arretent le prognamme.
c        cstatus: mots-cles fortran... ou "OVE" pour overwrite.

c     output: 
c        qexist: flag / existence du fichier 
c        qinterr: Pas de nom pour le fichier cherche.
 
c.......................................................................
c     YHS-oct-1993: Premiere version.
c     YHS-jul-2007: v1.5
c.......................................................................
      logical qexist, qinterr, qverbos
      integer lnom, unit
      character cformat*12, cstatus*12, namfil*(*)
c Local
      character ordrunix*132
c Begin:
      if (cstatus.eq.'old') cstatus='OLD'
      if (cstatus.eq.'new') cstatus='NEW'
      if (cstatus.eq.'ove') cstatus='OVE'
      if (cstatus.eq.'unknown') cstatus='UNKNOWN'
 
      qinterr=.false.
      qexist=.false.
 
      if (namfil.eq.' ') then 
          qinterr=.true.
          write(6,'(A)') '%Openam-Err> No filename.'
          return
      endif
 
      if (namfil.eq.'stop'.or.namfil.eq.'end'.or. 
     .    namfil.eq.'fin'.or.namfil.eq.'quit'.or.
     .    namfil.eq.'STOP'.or.namfil.eq.'END'.or.                     
     .    namfil.eq.'FIN'.or.namfil.eq.'QUIT') then 
         write(6,'(A)') 'Openam> Program stopped on user request.'
         stop                                                                   
      endif 
 
c     Checks if filename is consistent with the opening:
 
      inquire(file=namfil,exist=qexist)
      if (.not.qexist.and.cstatus.eq.'OLD') then
          qinterr=.true.
          write(6,'(/3A)') '%Openam-Err> File <',
     .         namfil(1:lnom),'> not found.'
          return
      endif
 
      if (qexist.and.cstatus.eq.'NEW') then
         write(6,'(/A)') 
     .      '%Openam-Err> This file exists:',namfil(1:lnom)
         stop
      else if (qexist.and.cstatus.eq.'OVE') then
         ordrunix='rm '//namfil(1:lnom)
         call system(ordrunix)
      endif
      if (cstatus.eq.'OVE') cstatus='NEW'
                                                                    
      if (qverbos) then
         write(6,'(/A,I2,2A)')
     . ' Openam> File on opening on unit ',unit,': ',namfil(1:lnom)
      endif
      open(file=namfil,form=cformat,
     .     status=cstatus,unit=unit)                
         
      return                                                                       
      end
c-----------------------------------------------------------------------
      subroutine string_split(chaine,taille,delimiteur,
     .                        souschaine,nbremax,nbre)
c
c     "Chaine" est coupee en "nbre" "souschaine" de part et d'autre du
c     "delimiteur"
c      YHS-Sep-93, Uppsala
c I/O:
      integer taille, nbremax, nbre
      character*(*) chaine, souschaine(*), delimiteur
c Local:
      integer icar, iprev
c
      nbre=1
      iprev=1
      souschaine(1)=chaine
      do icar=1,taille
         if (chaine(icar:icar).eq.delimiteur) then
            if (icar-1.ge.iprev) then
               souschaine(nbre)=chaine(iprev:icar-1)
               nbre=nbre+1
               if (nbre.le.nbremax) then
                  if (icar+1.le.taille.and.
     .               chaine(icar+1:taille).ne.' ') then
                     souschaine(nbre)=chaine(icar+1:taille) 
                  else
                     nbre=nbre-1
                     return
                  endif
               else
                  write(6,'(A,I6,A/A)') 
     .               ' %String_split-Err: more than ',nbremax,
     .               ' substrings in : ',chaine
                  return
               endif
            endif
            iprev=icar+1
         endif
      enddo
c
      return
      end
c
      subroutine stringcl(chaine,nonblancs)
c
c     Les caracteres "blancs" de la CHAINE sont retires (a gauche et au milieu).
c     L'entier NONBLANCS donne la position du dernier caractere.
c
c     YHS-Jan-95, Toulouse.
c     YHS-Oct-00, Bordeaux.
c I/O:
      integer nonblancs
      character*(*) chaine
c Local:
      integer icar, ncar, taille
c Begin:
      nonblancs=0
      taille=len(chaine)
      if (taille.le.0) return
c
      if (index(chaine(1:taille),' ').le.0) then
          nonblancs=taille
          return
      endif
c
c*****Nettoyage des blancs a gauche.
c     Premier non-blanc:
c
      do icar=1,taille
         if (chaine(icar:icar).ne.' ') goto 150
      enddo
      icar=taille
 150  continue
      chaine=chaine(icar:taille)
c
c*****Nettoyage des blancs au milieu.
c
          icar=1
          ncar=1
 170      continue
          icar=icar+1
          ncar=ncar+1
          if (chaine(icar:icar).eq.' ') then
              chaine=chaine(1:icar-1)//chaine(icar+1:taille) 
              icar=icar-1
          endif
          if (ncar.lt.taille-1) goto 170
c
      nonblancs=index(chaine,' ')-1
c
      return
      end
c----------------------------------------------------------------------
      subroutine rdmodfacs(uneig,nddlmax,nvec,numvec,freq,matvec,nddl)
 
c     ======================
c     Reads "CERFACS" files.
c     ======================

c    (CERFACS is the file format produced by diagonalization prognams
c     DIAGSTD, DIAGMAT, DIAGRTB, BLZPACK -all available on the web)
 
c     YHS-Nov-1996: premiere version, Toulouse (rdcerfacs).
c     YHS-Fev-2001: version 2.01 (Bordeaux).
c     YHS-Mar-2005: dernieres modifications, Lyon (version 2.02).
      implicit none
cI/O:
      integer nddl, nddlmax, nddlref, numvec(*), nvec, uneig
      double precision freq(*), matvec(nddlmax,*)
cLocal:
      integer nmotsmax
      parameter(nmotsmax=100)
      integer indnm_cfacs, ivec, nerr, nmots,
     .        i, ii, k
      logical qfirst, qfound, qold
      character carnum*1, lign132*132, mots(nmotsmax)*132, 
     .        prognam*11, progrer*14, progrwn*14
cDefaut:
      prognam=' Rdmodfacs>'
      progrer='%Rdmodfacs-Er>'
      progrwn='%Rdmodfacs-Wn>'

      nddl=0
      nerr=0
      k=0

c     Recherche de la partie significative du fichier:

      qfirst=.true.
      qold=.false.
      qfound=.false.
 100  continue
      read (uneig,'(A)',end=300,err=110) lign132
      goto 120
 110  continue
      nerr=nerr+1
 120  continue

      qfound=qfound.or.
     .      (index(lign132,' value ').gt.0.and.
     .       index(lign132,' vector ').gt.0.and.
     .       index(lign132,' residual ').le.0)
      qold=qold.or.
     .      (index(lign132,' VALUE ').gt.0.and.
     .       index(lign132,' VECTOR ').gt.0)
 
      if (.not.qfound.and..not.qold) goto 100

c     Lecture des frequences des modes:
c     _________________________________
 
      if (qfirst) then
          if (qold) then
          write(6,'(/2A)') prognam,
     .  ' Old Blzpack file format detected.'
          else
          write(6,'(/2A)') prognam,
     .  ' Blzpack file format detected.'
          endif
          qfirst=.false.
      endif
 
      ivec=0
 250  continue
      ivec=ivec+1
      if (ivec.gt.nvec) then
          ivec=nvec
          write(6,'(/2A,I5,A)') progrwn, 
     .  ' More than ',nvec,' vector(s) in file.'
          goto 300
      endif

      if (ivec.eq.2) then
          nddlref=k
      else if (ivec.gt.2.and.k.ne.nddlref) then
          write(6,'(/2A,I5,A,I6,A,I6,A)') progrer, 
     .  ' Vector ',ivec-1,' has ',k,' d.o.f. while previous ones had ',
     .    nddlref,' of them.'
          stop '*Corrupted file*'
      endif

      read(lign132,'(7X,I5,12X,G12.4)',end=240,err=240)
     .     numvec(ivec), freq(ivec)
 
      goto 255
 240  continue
      write(6,'(/2A/2A)') progrwn,
     .    ' Could not read frequency and vector number in ligne: ',
     .      lign132(1:72),'...'
 255  continue
 
      write(6,'(/A,I6)')
     .' Rdmodfacs> Eigenvector number:',
     .  numvec(ivec)
      write(6,'(A,1PG12.4)')
     .' Rdmodfacs> Corresponding eigenvalue:',
     .  freq(ivec)
 
      if (numvec(ivec).le.0)
     .    write(6,'(/A/A)')
     .  '%Rdmodfacs-W> Vector number was expected in:',
     .    lign132
 
      read(uneig,'(A)',end=230,err=230) lign132
 230  continue
      read(lign132,'(1X,A1)',end=232,err=232) carnum
 232  continue
      if ((qfound.and.carnum.ne.'=').or.
     .    (qold.and.carnum.ne.'-')) then
          write(6,'(2A/A)')
     .       ' %Rdmodfacs-Warning> Unexpected character ',
     .       ' in second column of line:',
     .    lign132
      endif
 
c     2) Lecture des coordonnees des modes:
c     _____________________________________
 
      k=0
 257  continue
      if (k.gt.nddlmax) then
          write(6,'(/2A,I6,A,I5)') progrer,' More than ',nddlmax,
     .  ' coordinates for vector ',ivec
          k=nddlmax
          goto 300
      endif
 
      read(uneig,'(A)',end=300,err=270) lign132
 
c     Nombre de coordonnees par ligne:
      call string_split(lign132,132,' ',
     .                  mots,nmotsmax,nmots)
 
      if (lign132.eq.' ') then
          read(uneig,'(A)',end=300,err=260) lign132
      else if (.not.qold.or.index(lign132,' VALUE ').le.0) then

c         Une ligne de coordonnees:

          read(lign132,*,end=258,err=270) (matvec(k+ii,ivec),ii=1,nmots)
          k=k+nmots

          goto 257
 258      continue
      endif
 
c     Mode suivant ?

 260  continue
      indnm_cfacs=index(lign132,'       VALUE')
      if (indnm_cfacs.le.0)
     .    indnm_cfacs=index(lign132,'       value')
      if (indnm_cfacs.gt.0) then
          goto 250
      else
          write(6,'(2A,A/A/A)') progrwn,
     .  ' Item VALUE not found in ligne: ',lign132,
     .  ' Remaining skipped.'
          goto 300
      endif
 
 270  continue
      write(6,'(2A,I6,A,I6)') progrer,
     .   ' While reading coordinate ',k+ii,' of vector ',ivec
      stop
 
 220  continue
c*****Ligne suivante de la lecture du fichier des modes en cours :
 
      goto 100
 
c     Fin de la lecture du fichier des modes:
c     =======================================
 
 300  continue
      nvec=ivec
      nddl=k

      return
      end
c----------------------------------------------------------------------
      subroutine writpdb(unpdb,xat,yat,zat,binfo,
     .           atonam,ires,resnam,segid,natom)
c
c     Ecriture d'un fichier en format pdb.
c     YHS-Mars-1996.
c
      implicit none
cI/O:
      integer unpdb, ires(*), natom
      double precision xat(*), yat(*), zat(*), binfo(*)
      character*4 atonam(*), resnam(*), segid(*)
cLocal:
      integer i, j, k
      character*5 atom
cBegin:
      write(6,'(/A)') ' Writpdb> Writing pdb file.'
c
      do i=1,natom
c
c     Un petit probleme avec le cadrage des noms des atomes:
c    'iHjj' ou ' NNN'
c
      atom=atonam(i)
      if (index(atonam(i),' ').gt.1) atom=' '//atonam(i)
c
c     write(unpdb,'(A,I7,1X,A4,A4,2X,I4,4X,3F8.3,6X,F6.2,6X,A)') 
      write(unpdb,'(A,I7,1X,A4,1X,A4,1X,I4,4X,3F8.3,6X,F6.2,6X,A)') 
     .      'ATOM', i, atom(1:4), resnam(i), ires(i), 
     .      xat(i), yat(i), zat(i), binfo(i), segid(i)
      enddo
      write(unpdb,'(A)') 'END'
c
      write(6,'(A,I6,A)') ' Writpdb> ',natom,' atoms saved.'
      return
      end
c-----------------------------------------------------------------------
      subroutine trier(y,npoint,nmax,ysort,iord,qcrois)
CoS=====================================================================
CoS...Trier: Trivial sort of y
CoS---------------------------------------------------------------------
CoS   Note that it may be slow. 
CoS   Much faster algorithms do exist (quick-sort).
CoS---------------------------------------------------------------------
c     Increasing order (qcrois=T) or decreasing one.
c     YHS-Jun-2002: Premiere version (Bordeaux).
c     YHS-Sep-2002: v1.01 (Bordeaux).
c     YHS-Oct-2010: v1.02 (Nantes).

      implicit none
      logical qcrois
      integer i, icur, iord(*), j, nmax, npoint
      double precision y(*), ycur, ysort(*)
      character progrer*10

      progrer='%Trier-Er>'

      if (npoint.gt.nmax) then
          write(6,'(A,I9,A,I9,A)') progrer,npoint,
     .  ' points to be sorted, i.e., more than ',nmax,' Sorry.'
          stop
      endif

      do i=1,npoint
         ysort(i)=y(i)
         iord(i)=i
      enddo

      do i=1,npoint
        do j=1,npoint
          if (qcrois) then
            if (ysort(i).lt.ysort(j)) then
                ycur=ysort(i)
                icur=iord(i)
                ysort(i)=ysort(j)
                ysort(j)=ycur
                iord(i)=iord(j)
                iord(j)=icur
            endif
          else
            if (ysort(i).gt.ysort(j)) then
                ycur=ysort(i)
                icur=iord(i)
                ysort(i)=ysort(j)
                ysort(j)=ycur
                iord(i)=iord(j)
                iord(j)=icur
            endif
          endif
        enddo
      enddo

      return
      end
c-----------------------------------------------------------------------
      subroutine rdatompdb(unpdb,ssusel,qhet,xat,yat,zat,binfo,
     .           atonam,iresat,resnam,ssunam,segid,natmax,natom,
     .           fatres,nresmx,nres,codpdb,qerror,prtlev)
CoS=====================================================================
CoS...Rdatompdb: reads a PDB coordinate file ligne by ligne.
CoS---------------------------------------------------------------------
CoS  *Lignes read:
CoS   Only those starting by 'ATOM' (also HETATM if qhet=T).
CoS   Only those from the chosen subunit.
CoS   First MODEL only.
CoS
CoS  *Gets PDB code, expected in columns 63:66 from HEADer ligne.
CoS
CoS  *A negative sign can be given to a residue identifier.
CoS   This may happen when it can NOT be read as an integer number.
CoS
CoS   Purpose: keeping the information that the current residue is
CoS   different from the previously read one.
CoS   Ex: 139A, 139B, 139C become: 139, -139, 139.
CoS---------------------------------------------------------------------
c     fatres(i): numero du premier atome du residu i.
c-----------------------------------------------------------------------
c     YHS-Nov-1996: Premiere version (Toulouse).
c     YHS-Jan-2007: Version 1.32 (Lyon).
c     YHS-Jun-2016: Version 1.43 bis (Nantes).
 
      implicit none
cI/O:
      integer unpdb, natmax, iresat(*), natom,  lnom,
     .        nresmx, nres, fatres(*), prtlev
      double precision xat(*), yat(*), zat(*), binfo(*)
      logical qerror, qhet
      character atonam(*)*4, codpdb*4, resnam(*)*4, segid(*)*4, 
     .        ssusel*1, ssunam(*)*1
cLocal:
      integer iatom, irs, irsprev, ndiff, nerr, ntit,
     .        i, j, k, ii
      double precision bfact, x, y, z
      character atncur*5, lign80*80, notuse*6, numbers*11,
     .        prognam*11, progrer*14, progrwn*14, 
     .        ren*4, resid*7, residprev*7, residrd*7, segat*4, ssu*1
cBegin:
      prognam=' Rdatompdb>'
      if (prtlev.gt.0)
     .write(6,'(/2A)') prognam,' Reading pdb file.'

      numbers='-0123456789'
      progrer='%Rdatompdb-Er>'
      progrwn='%Rdatompdb-Er>'
      qerror=.false.
      nerr=0
 
      codpdb='NONE'
      residprev='X'
      irsprev=-1
      ndiff=0
      ntit=0
      nres=0
      iatom=0
 105  continue   
      read(unpdb,'(A)',end=200,err=110) lign80 
  
      goto 120                                
 110  continue
      nerr=nerr+1                            
 
 120  continue                              
c     Try to catch the PDB code of this structure: 
      if (lign80(1:4).eq.'HEAD') then
c         Usually there:
          codpdb=lign80(63:66)
          call stringcl(codpdb,lnom)
          if (lnom.ne.4) then
c             Often also here:
              codpdb=lign80(73:76)
              call stringcl(codpdb,lnom)
c             Maybe the last word of the ligne ?
              if (lnom.ne.4) then
                  call stringcl(lign80,lnom)
                  codpdb=lign80(lnom-3:lnom)
              endif
          endif
          goto 105
      endif

      if (lign80(1:4).eq.'ATOM'.or.
     .   (qhet.and.lign80(1:6).eq.'HETATM')) then
      segat=' '
c     Residue number (irs) columns are (used to be ?) ill-defined in PDB.
c     Notuse: usually empty columns.
      read(lign80,'(12X,A4,1X,A4,A1,A7,1X,3F8.3,6X,F6.2,A6,A4)',
     .     end=195,err=195) 
     .     atncur, ren, ssu, resid, x, y, z, bfact, notuse, segat 

      if (iatom.lt.natmax) then
          if (ssu.eq.ssusel.or.ssusel.eq.' ') then
          iatom=iatom+1
          xat(iatom)=x
          yat(iatom)=y
          zat(iatom)=z
          binfo(iatom)=bfact
 
          call stringcl(atncur,lnom)
          atonam(iatom)=atncur
          call stringcl(ren,lnom)
          resnam(iatom)=ren
          ssunam(iatom)=ssu
          segid(iatom)=segat
          residrd=resid
          call stringcl(resid,lnom)

          if (resid.eq.residprev) then
              irs=irsprev
          else
              if (index(numbers,resid(1:1)).gt.0.and.
     .            index(numbers,resid(lnom:lnom)).gt.0) then
                  read(resid,*,end=180,err=180) irs
                  goto 185
 180              continue
                  write(6,'(/3A)') progrer,
     .          ' Wrong residue identifier: ',residrd
                  stop '*Can not handle that one (sorry)*'
 185              continue
              else
                  ndiff=ndiff+1
                  irs=-irsprev
                  if (prtlev.gt.0)
     .            write(6,'(4A)') progrwn,' Residue identifier: ',
     .            resid(1:lnom),' is atypical (not an integer number).'
              endif
          endif
          iresat(iatom)=irs
CoS
CoS       Residue numbers found in PDB are not trusted.               
CoS       Differences in residue identifiers or chain name mark a new residue.
CoS       Differences in segment names are not taken into account:
CoS       The information found in last column is not expected to be standard.

          if (iatom.eq.1.or.resid.ne.residprev.or.
     .        ssunam(iatom).ne.ssunam(iatom-1)) then
              nres=nres+1
              if (nres.gt.nresmx) then
                  write(6,'(/2A/A,I6)') progrer,
     .          ' Too many residues in this file.',
     .          ' Maximum allowed is = ',nresmx
                  stop '*Larger arrays required*'
              endif
              residprev=resid
              irsprev=irs
              fatres(nres)=iatom
          else
              if (resnam(iatom).ne.resnam(iatom-1))
     .        write(6,'(4A)') progrer,
     .      ' Several kinds of residues with id: ',resid,ssunam(iatom)  
          endif
          endif
      else
          write(6,'(/2A/A,I6)') progrer,
     .      ' Too many atoms in this file.',
     .      ' Maximum allowed is = ',natmax
          stop '*Larger arrays required*'
      endif
      else if (lign80(1:6).eq.'REMARK'.and.prtlev.gt.0) then
          ntit=ntit+1
          if (ntit.le.10) then
              write(6,'(A)') lign80
          else if (ntit.eq.11) then
              write(6,'(A)') ' .... '
          endif
      else if (lign80(1:6).eq.'ENDMDL') then
          write(6,'(/2A)') progrwn,
     .  ' ENDMDL encountered. Remaining ignored.'
          goto 200
      endif
 
c     2) Ligne suivante du fichier pdb :
 
      goto 105
 
c     3) Fin de la lecture du fichier pdb :

c     Erreur de lecture:
 195  continue
      qerror=.true.
      write(6,'(/2A/A)') progrer,
     .    ' Unable to read coordinate ligne: ',lign80
 
 200  continue 
      if (prtlev.gt.1) then
      write(6,'(2A)') prognam,' End of file reached.'
      write(6,'(2A,I6)') prognam,' Number of I/O errors: ',
     .            nerr
      endif
 
      natom=iatom
      fatres(nres+1)=natom+1
      irs=0
      if (natom.gt.0) irs=iresat(natom)
 
      write(6,'(/2A,I6)') prognam, 
     .           ' Number of residues found = ',nres 
      write(6,'(A,I6)') 
     .'            First residue number     = ',iresat(1),
     .'            Last  residue number     = ',irs,
     .'            Number of atoms found    = ',natom
      if (prtlev.gt.0.and.nres.gt.0)
     .write(6,'(A,F8.1)') 
     .'            Mean number per residue  = ',float(natom)/float(nres)
      if (ndiff.gt.0)
     .write(6,'(/A,I6)') 
     .'            N.of negative residue id.= ',ndiff
 
      if (natom.eq.0) then
          write(6,'(2A)') progrer,' No atom found in file.'
          qerror=.true.
      endif
      if (nres.eq.0) then
          write(6,'(2A)') progrer,' No residue found in file.'
          qerror=.true.
      endif

      close(unpdb)
      return
      end
c-----------------------------------------------------------------------
      subroutine segidtossu(segid,natom,qforce,qseg,ssunam,nch,prtlev)
CoS=====================================================================
CoS...segidtossu: Chain names are built from Charmm segment identifiers.
CoS---------------------------------------------------------------------
CoS   Action:
CoS   -------
CoS  *A character (chain/subunit name) is given to each CHARMM segment.
CoS
CoS  *qforce=T: Even if there are already valid (non-blank) chain names.
CoS
CoS   Properties:
CoS   -----------
CoS  *Charmm segment identifiers comes from last column of PDB file.
CoS   Herein, they are expected to have FOUR characters.
CoS
CoS  *Characters are assigned one after the other, from A to 9.
CoS   If there are too many segments, assigment continues, from A to 9.
CoS
CoS  *Segment found: qseg=true. Not found, no valid chain name: X given.
CoS---------------------------------------------------------------------
c     YHS-Dec-2011: Version 1.10 (Nantes).
c     YHS-Jun-2016: Version 1.22.
 
      implicit none
cI/O:
      integer i, ich, natom, nch, prtlev
      logical qforce, qseg
      character segid(*)*4, ssunam(*)*1
cLocal:
      integer lnom, lnomp, ncarmx
      parameter(lnomp=10,ncarmx=36)
      character caracteres*(ncarmx), name*(lnomp),
     .         proglv1*(lnomp+5),prognam*(lnomp+2), progrwn*(lnomp+5) 
cBegin:      
      name='Segidtossu'
      prognam=' '//name//'>'
      progrwn='%'//name//'-Wn>'
      proglv1='%'//name//'-L1>'

      if (prtlev.gt.0)
     .write(6,'(/2A)') proglv1,' Fixing chain names.'

      qseg=.false.
      nch=0
      if (natom.le.0) return

      caracteres='ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'

      if (qforce) goto 500

c     Noms de chaine OK ?
      nch=1
      do i=1,natom
         if (index(caracteres,ssunam(i)).le.0) goto 500 
         if (i.gt.1.and.ssunam(i).ne.ssunam(i-1)) nch=nch+1
      enddo
      write(6,'(/2A)') prognam,' Standard PDB chain names found.'
      return

 500  continue
      write(6,'(/2A)') prognam,
     .    ' Chain names to be built from segment identifiers.'

      do i=1,natom
         call stringcl(segid(i),lnom)
         if (lnom.ne.4) goto 600
      enddo
      qseg=.true.

      ssunam(1)='A'
      nch=1
      ich=1
      do i=2,natom
         if (segid(i).eq.segid(i-1)) then
             ssunam(i)=ssunam(i-1)
         else
             nch=nch+1
             ich=ich+1
             if (ich.gt.ncarmx) ich=1
             ssunam(i)=caracteres(ich:ich)
         endif
      enddo 
      return

 600  continue
      write(6,'(2A)') progrwn,' No regular segment identifier found.'
      do i=1,natom
         ssunam(i)='X'
      enddo

      return
      end
